/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;

public class IBMVmInfo
extends VmInfo {
    @Argument
    public DumpType type = DumpType.SYSTEM;
    @Argument
    public boolean compress = false;
    private String pid;

    IBMVmInfo(String pid, String description, boolean heapDumpEnabled, String proposedFileName, IHeapDumpProvider heapDumpProvider) {
        super(0, description, heapDumpEnabled, proposedFileName, heapDumpProvider);
        this.setPid(pid);
    }

    void setPid(String s) {
        this.pid = s;
        try {
            int i = Integer.parseInt(s.split("\\.")[0]);
            this.setPid(i);
        }
        catch (NumberFormatException numberFormatException) {
            this.setPid(-1);
        }
    }

    String getPidName() {
        return this.pid;
    }

    String agentCommand() {
        if (this.type == DumpType.SYSTEM) {
            return "system";
        }
        if (this.type == DumpType.HEAP) {
            return "heap+java";
        }
        if (this.type == DumpType.JAVA) {
            return "java";
        }
        return null;
    }

    public String getProposedFileName() {
        String ret = super.getProposedFileName();
        if (ret == null) {
            Date date = new Date();
            if (this.type == DumpType.SYSTEM) {
                ret = this.compress ? MessageFormat.format("core.{0,date,yyyyMMdd.HHmmss}.{1}.0001.dmp.zip", date, this.pid) : MessageFormat.format("core.{0,date,yyyyMMdd.HHmmss}.{1}.0001.dmp", date, this.pid);
            } else if (this.type == DumpType.HEAP) {
                ret = this.compress ? MessageFormat.format("heapdump.{0,date,yyyyMMdd.HHmmss}.{1}.0001.phd.gz", date, this.pid) : MessageFormat.format("heapdump.{0,date,yyyyMMdd.HHmmss}.{1}.0001.phd", date, this.pid);
            } else if (this.type == DumpType.JAVA) {
                ret = MessageFormat.format("javacore.{0,date,yyyyMMdd.HHmmss}.{1}.0001.txt", date, this.pid);
            }
        }
        return ret;
    }
}

