/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.internal.GarbageCleaner;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.ParserPlugin;
import org.eclipse.mat.parser.internal.PreliminaryIndexImpl;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.internal.SnapshotImplBuilder;
import org.eclipse.mat.parser.internal.oql.OQLQueryImpl;
import org.eclipse.mat.parser.internal.util.ParserRegistry;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.SnapshotFormat;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotFactoryImpl
implements SnapshotFactory.Implementation {
    private Map<File, SnapshotEntry> snapshotCache = new HashMap<File, SnapshotEntry>();

    public ISnapshot openSnapshot(File file, Map<String, String> args, IProgressListener listener) throws SnapshotException {
        ISnapshot answer = null;
        SnapshotEntry entry = this.snapshotCache.get(file);
        if (entry != null && (answer = (ISnapshot)entry.snapshot.get()) != null) {
            SnapshotEntry snapshotEntry = entry;
            snapshotEntry.usageCount = snapshotEntry.usageCount + 1;
            return answer;
        }
        String name = file.getAbsolutePath();
        int p = name.lastIndexOf(46);
        String prefix = p >= 0 ? name.substring(0, p + 1) : String.valueOf(name) + ".";
        try {
            File indexFile = new File(String.valueOf(prefix) + "index");
            if (indexFile.exists()) {
                if (file.lastModified() < indexFile.lastModified()) {
                    answer = SnapshotImpl.readFromFile(file, prefix, listener);
                } else {
                    String message = MessageUtil.format((String)Messages.SnapshotFactoryImpl_ReparsingHeapDumpAsIndexOutOfDate, (Object[])new Object[]{file.getPath(), new Date(file.lastModified()), indexFile.getPath(), new Date(indexFile.lastModified())});
                    listener.sendUserMessage(IProgressListener.Severity.INFO, message, null);
                    listener.subTask(Messages.SnapshotFactoryImpl_ReparsingHeapDumpWithOutOfDateIndex);
                }
            }
        }
        catch (IOException ignore_and_reparse) {
            String text = ignore_and_reparse.getMessage() != null ? ignore_and_reparse.getMessage() : ignore_and_reparse.getClass().getName();
            String message = MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_ReparsingHeapDump, (Object[])new Object[]{text});
            listener.sendUserMessage(IProgressListener.Severity.WARNING, message, (Throwable)ignore_and_reparse);
            listener.subTask(message);
        }
        if (answer == null) {
            this.deleteIndexFiles(file);
            answer = this.parse(file, prefix, args, listener);
        }
        entry = new SnapshotEntry(1, answer);
        this.snapshotCache.put(file, entry);
        return answer;
    }

    public synchronized void dispose(ISnapshot snapshot) {
        Iterator<SnapshotEntry> iter = this.snapshotCache.values().iterator();
        while (iter.hasNext()) {
            SnapshotEntry entry = iter.next();
            ISnapshot s = (ISnapshot)entry.snapshot.get();
            if (s == null) {
                iter.remove();
                continue;
            }
            if (s != snapshot) continue;
            SnapshotEntry snapshotEntry = entry;
            snapshotEntry.usageCount = snapshotEntry.usageCount - 1;
            if (entry.usageCount == 0) {
                snapshot.dispose();
                iter.remove();
            }
            return;
        }
        if (snapshot != null) {
            snapshot.dispose();
        }
    }

    public IOQLQuery createQuery(String queryString) throws SnapshotException {
        return new OQLQueryImpl(queryString);
    }

    public List<SnapshotFormat> getSupportedFormats() {
        ArrayList<SnapshotFormat> answer = new ArrayList<SnapshotFormat>();
        for (ParserRegistry.Parser parser : ParserPlugin.getDefault().getParserRegistry().delegates()) {
            answer.add(parser.getSnapshotFormat());
        }
        return answer;
    }

    private final ISnapshot parse(File file, String prefix, Map<String, String> args, IProgressListener listener) throws SnapshotException {
        ParserRegistry registry = ParserPlugin.getDefault().getParserRegistry();
        List<ParserRegistry.Parser> parsers = registry.matchParser(file.getName());
        if (parsers.isEmpty()) {
            parsers.addAll(registry.delegates());
        }
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (ParserRegistry.Parser parser : parsers) {
            IIndexBuilder indexBuilder = parser.create(IIndexBuilder.class, "indexBuilder");
            if (indexBuilder == null) continue;
            try {
                indexBuilder.init(file, prefix);
                XSnapshotInfo snapshotInfo = new XSnapshotInfo();
                snapshotInfo.setPath(file.getAbsolutePath());
                snapshotInfo.setPrefix(prefix);
                snapshotInfo.setProperty("$heapFormat", (Serializable)((Object)parser.getId()));
                if (Boolean.parseBoolean(args.get("keep_unreachable_objects"))) {
                    snapshotInfo.setProperty("keep_unreachable_objects", Integer.valueOf(2048));
                }
                PreliminaryIndexImpl idx = new PreliminaryIndexImpl(snapshotInfo);
                indexBuilder.fill(idx, listener);
                SnapshotImplBuilder builder = new SnapshotImplBuilder(idx.getSnapshotInfo());
                int[] purgedMapping = GarbageCleaner.clean(idx, builder, args, listener);
                indexBuilder.clean(purgedMapping, listener);
                SnapshotImpl snapshot = builder.create(parser, listener);
                snapshot.calculateDominatorTree(listener);
                return snapshot;
            }
            catch (IOException ioe) {
                errors.add(ioe);
                indexBuilder.cancel();
            }
            catch (Exception e) {
                indexBuilder.cancel();
                throw SnapshotException.rethrow((Throwable)e);
            }
        }
        if (errors.size() > 1) {
            MultiStatus status = new MultiStatus("org.eclipse.mat.parser", 0, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ErrorOpeningHeapDump, (Object[])new Object[]{file.getName()}), null);
            for (IOException error : errors) {
                status.add((IStatus)new Status(4, "org.eclipse.mat.parser", 0, error.getLocalizedMessage(), (Throwable)error));
            }
            CoreException ce = new CoreException((IStatus)status);
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_OpeningHeapDump, (Object[])new Object[]{file.getName()}), (Throwable)ce);
        }
        if (errors.size() == 1) {
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_OpeningHeapDump, (Object[])new Object[]{file.getName()}), (Throwable)errors.get(0));
        }
        throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_NoParserRegistered, (Object[])new Object[]{file.getName()}));
    }

    private void deleteIndexFiles(File file) {
        Pattern logPattern;
        Pattern indexPattern;
        String filename;
        int p;
        String fragment;
        File[] files;
        File directory = file.getParentFile();
        if (directory == null) {
            directory = new File(".");
        }
        if ((files = directory.listFiles(new FileFilter(fragment = (p = (filename = file.getName()).lastIndexOf(46)) >= 0 ? filename.substring(0, p) : filename, indexPattern = Pattern.compile("\\.(.*\\.)?index$"), logPattern = Pattern.compile("\\.inbound\\.index.*\\.log$")){
            private final /* synthetic */ String val$fragment;
            private final /* synthetic */ Pattern val$indexPattern;
            private final /* synthetic */ Pattern val$logPattern;
            {
                this.val$fragment = string;
                this.val$indexPattern = pattern;
                this.val$logPattern = pattern2;
            }

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                String name = f.getName();
                return name.startsWith(this.val$fragment) && (this.val$indexPattern.matcher(name).matches() || this.val$logPattern.matcher(name).matches());
            }
        })) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
        }
    }

    private static class SnapshotEntry {
        private int usageCount;
        private WeakReference<ISnapshot> snapshot;

        public SnapshotEntry(int usageCount, ISnapshot snapshot) {
            this.usageCount = usageCount;
            this.snapshot = new WeakReference<ISnapshot>(snapshot);
        }
    }
}

