/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.net.URL;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.MessageUtil;

public class TotalsRow {
    private static final URL SUM = TotalsRow.class.getResource("/META-INF/icons/misc/sum.gif");
    private static final URL SUM_PLUS = TotalsRow.class.getResource("/META-INF/icons/misc/sum_plus.gif");
    private static final NumberFormat fmt = DecimalFormat.getInstance();
    private Double[] totals;
    private int filteredItems;
    private int numberOfItems;
    private int visibleItems;

    public int getVisibleItems() {
        return this.visibleItems;
    }

    public void setVisibleItems(int visibleItems) {
        this.visibleItems = visibleItems;
    }

    public int getFilteredItems() {
        return this.filteredItems;
    }

    void setFilteredItems(int filteredItems) {
        this.filteredItems = filteredItems;
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }

    void setNumberOfItems(int numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    void setTotals(Double[] totals) {
        this.totals = totals;
    }

    public URL getIcon() {
        return this.visibleItems < this.numberOfItems ? SUM_PLUS : SUM;
    }

    public boolean isVisible() {
        return this.numberOfItems > 1 || this.filteredItems > 0 || this.visibleItems < this.numberOfItems;
    }

    public String getLabel(int columnIndex) {
        if (columnIndex == 0) {
            return this.getFirstItemText();
        }
        if (this.totals == null) {
            return "";
        }
        if (columnIndex < 1 || columnIndex >= this.totals.length) {
            return "";
        }
        if (this.totals[columnIndex] == null) {
            return "";
        }
        return fmt.format(this.totals[columnIndex].doubleValue());
    }

    private String getFirstItemText() {
        boolean hasMore = this.numberOfItems > this.visibleItems;
        boolean hasTotals = this.totals != null && this.totals[0] != null;
        boolean hasFiltered = this.filteredItems > 0;
        String msg = null;
        msg = hasMore ? MessageUtil.format(Messages.TotalsRow_Label_TotalVisible, this.visibleItems, this.numberOfItems) : MessageUtil.format(Messages.TotalsRow_Label_Total, this.numberOfItems);
        if (hasTotals) {
            msg = String.valueOf(msg) + " / " + fmt.format(this.totals[0].doubleValue());
        }
        if (hasFiltered) {
            msg = String.valueOf(msg) + MessageUtil.format(" " + Messages.TotalsRow_Label_Filtered, this.filteredItems);
        }
        return msg;
    }
}

