/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.results;

import com.ibm.icu.text.NumberFormat;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.report.internal.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResult
implements IResultTable,
IIconProvider {
    private List<Pair> rows = new ArrayList<Pair>();

    public <L> PropertyResult(Object subject, String ... properties) {
        try {
            HashMap<String, PropertyDescriptor> name2prop = new HashMap<String, PropertyDescriptor>();
            BeanInfo info = Introspector.getBeanInfo(subject.getClass());
            Object[] objectArray = info.getPropertyDescriptors();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor d = objectArray[n2];
                Method readMethod = d.getReadMethod();
                if (readMethod != null) {
                    name2prop.put(d.getName(), d);
                }
                ++n2;
            }
            if (properties == null || properties.length == 0) {
                properties = name2prop.keySet().toArray(new String[name2prop.size()]);
            }
            objectArray = properties;
            n = properties.length;
            n2 = 0;
            while (n2 < n) {
                Object property = objectArray[n2];
                PropertyDescriptor d = (PropertyDescriptor)name2prop.get(property);
                if (d != null) {
                    Object v = d.getReadMethod().invoke(subject, null);
                    Pair p = new Pair(this.fixName(d.getName()), this.fixValue(v));
                    this.rows.add(p);
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String fixValue(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Number) {
            return NumberFormat.getNumberInstance().format(v);
        }
        return String.valueOf(v);
    }

    private String fixName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 10);
        int ii = 0;
        while (ii < name.length()) {
            char ch = name.charAt(ii);
            if (ii == 0) {
                buf.append(Character.toUpperCase(ch));
            } else if (Character.isUpperCase(ch)) {
                buf.append(' ').append(ch);
            } else {
                buf.append(ch);
            }
            ++ii;
        }
        return buf.toString();
    }

    @Override
    public ResultMetaData getResultMetaData() {
        return null;
    }

    @Override
    public final Column[] getColumns() {
        return new Column[]{new Column(Messages.PropertyResult_Column_Name, String.class), new Column(Messages.PropertyResult_Column_Value, String.class)};
    }

    @Override
    public final int getRowCount() {
        return this.rows.size();
    }

    @Override
    public final Object getRow(int rowId) {
        return this.rows.get(rowId);
    }

    @Override
    public final Object getColumnValue(Object row, int columnIndex) {
        Pair pair = (Pair)row;
        switch (columnIndex) {
            case 0: {
                return pair.getName();
            }
            case 1: {
                return pair.getValue();
            }
        }
        return null;
    }

    @Override
    public URL getIcon(Object row) {
        return null;
    }

    @Override
    public IContextObject getContext(Object row) {
        return null;
    }

    private static class Pair {
        private String name;
        private String value;

        Pair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

