/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.actions.ImportReportAction;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.actions.ExecuteQueryAction;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GettingStartedWizard
extends Wizard {
    public static final String HIDE_WIZARD_KEY = "hideGettingStartedWizard";
    Action action;
    HeapEditor editor;
    ChoicePage choicePage;
    PackagePage packagePage;
    OpenReportsPage openReportsPage;

    public GettingStartedWizard(HeapEditor editor) {
        this.editor = editor;
        this.setWindowTitle(Messages.GettingStartedWizard_GettingStartedWizard);
    }

    public void addPages() {
        this.choicePage = new ChoicePage();
        this.addPage((IWizardPage)this.choicePage);
        this.packagePage = new PackagePage();
        this.addPage((IWizardPage)this.packagePage);
        this.openReportsPage = new OpenReportsPage();
        this.addPage((IWizardPage)this.openReportsPage);
    }

    public boolean canFinish() {
        return this.action != null;
    }

    public boolean performFinish() {
        Preferences prefs = MemoryAnalyserPlugin.getDefault().getPluginPreferences();
        prefs.setValue(HIDE_WIZARD_KEY, !this.choicePage.askAgain.getSelection());
        if (this.action != null) {
            this.action.run();
        }
        return true;
    }

    public boolean performCancel() {
        Preferences prefs = MemoryAnalyserPlugin.getDefault().getPluginPreferences();
        prefs.setValue(HIDE_WIZARD_KEY, !this.choicePage.askAgain.getSelection());
        return true;
    }

    private static class ChoicePage
    extends WizardPage
    implements Listener {
        private Button componentReport;
        private Button leakReport;
        private Button openReports;
        private Button askAgain;

        public ChoicePage() {
            super("");
            this.setTitle(Messages.GettingStartedWizard_GettingStarted);
            this.setDescription(Messages.GettingStartedWizard_ChooseOneOfReports);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(composite);
            Composite choices = new Composite(composite, 0);
            GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)choices);
            GridLayoutFactory.fillDefaults().applyTo(choices);
            this.leakReport = new Button(choices, 16);
            this.leakReport.setText(Messages.GettingStartedWizard_LeakSuspectReport);
            this.leakReport.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            this.leakReport.addListener(13, (Listener)this);
            Label description = new Label(choices, 64);
            description.setText(Messages.GettingStartedWizard_LeakSuspectReportDescription);
            GridDataFactory.fillDefaults().indent(18, 0).hint(description.computeSize(300, -1)).applyTo((Control)description);
            description.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            this.componentReport = new Button(choices, 16);
            this.componentReport.setText(Messages.GettingStartedWizard_ComponentReport);
            this.componentReport.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            this.componentReport.addListener(13, (Listener)this);
            description = new Label(choices, 64);
            description.setText(Messages.GettingStartedWizard_ComponentReportDescription);
            GridDataFactory.fillDefaults().indent(18, 0).hint(description.computeSize(300, -1)).applyTo((Control)description);
            description.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            this.openReports = new Button(choices, 16);
            this.openReports.setText(Messages.GettingStartedWizard_ReOpenExistingReports);
            this.openReports.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            this.openReports.addListener(13, (Listener)this);
            description = new Label(choices, 64);
            description.setText(Messages.GettingStartedWizard_ExistingReportsLocation);
            GridDataFactory.fillDefaults().indent(18, 0).hint(description.computeSize(300, -1)).applyTo((Control)description);
            description.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            this.askAgain = new Button(composite, 32);
            this.askAgain.setSelection(true);
            this.askAgain.setText(Messages.GettingStartedWizard_ShowThisDialog);
            this.askAgain.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            Preferences prefs = MemoryAnalyserPlugin.getDefault().getPluginPreferences();
            this.askAgain.setSelection(!prefs.getBoolean(GettingStartedWizard.HIDE_WIZARD_KEY));
            this.setControl((Control)composite);
        }

        public boolean canFlipToNextPage() {
            return this.componentReport.getSelection() || this.openReports.getSelection();
        }

        public IWizardPage getNextPage() {
            if (this.componentReport.getSelection()) {
                return this.getWizard().packagePage;
            }
            if (this.openReports.getSelection()) {
                this.getWizard().openReportsPage.loadReportList();
                return this.getWizard().openReportsPage;
            }
            return null;
        }

        public void handleEvent(Event event) {
            if (event.widget == this.componentReport) {
                this.getWizard().action = null;
            } else if (event.widget == this.openReports) {
                this.getWizard().action = null;
            } else if (event.widget == this.leakReport) {
                this.getWizard().action = new ExecuteQueryAction((MultiPaneEditor)this.getWizard().editor, "default_report org.eclipse.mat.api:suspects");
            }
            this.getWizard().getContainer().updateButtons();
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.getWizard().action = null;
            }
            super.setVisible(visible);
        }

        public GettingStartedWizard getWizard() {
            return (GettingStartedWizard)super.getWizard();
        }
    }

    private static class OpenReportsPage
    extends WizardPage {
        TableViewer viewer;

        public OpenReportsPage() {
            super("");
            this.setTitle(Messages.GettingStartedWizard_ReOpenReport);
            this.setDescription(Messages.GettingStartedWizard_ReOpenExistingReport);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            TableColumnLayout layout = new TableColumnLayout();
            composite.setLayout((Layout)layout);
            this.viewer = new TableViewer(composite, 67588);
            TableColumn column = new TableColumn(this.viewer.getTable(), 0);
            column.setText(Messages.GettingStartedWizard_Report);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, true));
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((File)element).getName();
                }
            });
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
                File[] fileList;

                public Object[] getElements(Object inputElement) {
                    return this.fileList;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    if (newInput instanceof ISnapshot) {
                        try {
                            ISnapshot snapshot = (ISnapshot)newInput;
                            String prefix = snapshot.getSnapshotInfo().getPath();
                            int p = prefix.lastIndexOf(File.separatorChar);
                            if (p >= 0) {
                                prefix = prefix.substring(p + 1);
                            }
                            if ((p = prefix.lastIndexOf(46)) >= 0) {
                                prefix = prefix.substring(0, p);
                            }
                            final String fragment = prefix;
                            final Pattern regex = Pattern.compile(".*\\.zip$");
                            this.fileList = new File(snapshot.getSnapshotInfo().getPath()).getParentFile().listFiles(new FilenameFilter(){

                                public boolean accept(File dir, String name) {
                                    return name.startsWith(fragment) && regex.matcher(name).matches();
                                }
                            });
                        }
                        catch (PatternSyntaxException patternSyntaxException) {}
                    }
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OpenReportsPage.this.getWizard().action = new ImportReportAction(OpenReportsPage.this.getWizard().editor, (File)((IStructuredSelection)event.getSelection()).getFirstElement());
                    OpenReportsPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.setControl((Control)composite);
        }

        public void loadReportList() {
            this.viewer.setInput((Object)this.getWizard().editor.getSnapshotInput().getSnapshot());
        }

        public boolean canFlipToNextPage() {
            return false;
        }

        public GettingStartedWizard getWizard() {
            return (GettingStartedWizard)super.getWizard();
        }
    }

    private static class PackagePage
    extends WizardPage
    implements ModifyListener {
        public PackagePage() {
            super("");
            this.setTitle(Messages.GettingStartedWizard_SelectClasses);
            this.setDescription(Messages.GettingStartedWizard_SpecifyRegularExpression);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(composite);
            Label label = new Label(composite, 0);
            label.setText(Messages.GettingStartedWizard_Package);
            Text regex = new Text(composite, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)regex);
            regex.addModifyListener((ModifyListener)this);
            this.setControl((Control)composite);
        }

        public void modifyText(ModifyEvent event) {
            try {
                String text = ((Text)event.widget).getText();
                if (!"".equals(text)) {
                    Pattern.compile(text);
                    this.getWizard().action = new ExecuteQueryAction((MultiPaneEditor)this.getWizard().editor, "component_report " + text);
                }
                if (this.getErrorMessage() != null) {
                    this.setErrorMessage(null);
                }
            }
            catch (PatternSyntaxException e) {
                this.setErrorMessage(e.getMessage());
                this.getWizard().action = null;
            }
            this.getWizard().getContainer().updateButtons();
        }

        public boolean canFlipToNextPage() {
            return false;
        }

        public GettingStartedWizard getWizard() {
            return (GettingStartedWizard)super.getWizard();
        }
    }
}

