/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FileOpenDialogEditor
extends ArgumentEditor {
    private static final String LAST_DIRECTORY_KEY = String.valueOf(FileOpenDialogEditor.class.getName()) + ".lastDir";
    protected Object value;
    protected Text text;
    protected Button openButton;
    protected Composite parent;

    public FileOpenDialogEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item) {
        super(parent, context, descriptor, item);
        this.setFont(item.getFont());
        this.setBackground(item.getBackground());
        this.parent = parent;
        this.createContents();
    }

    protected void createContents() {
        this.setLayout(new FileOpenDialogEditorLayout());
        this.text = new Text((Composite)this, 16384);
        this.text.setFont(this.item.getFont());
        this.text.setBackground(this.item.getBackground());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    FileOpenDialogEditor.this.editingDone();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileOpenDialogEditor.this.editingDone();
            }
        });
        this.openButton = new Button((Composite)this, 0);
        this.openButton.setFont(this.item.getFont());
        this.openButton.setText("...");
        this.openButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog;
                File f;
                String s;
                Preferences prefs = MemoryAnalyserPlugin.getDefault().getPluginPreferences();
                String lastDirectory = prefs.getString(LAST_DIRECTORY_KEY);
                if (FileOpenDialogEditor.this.text.getText() != null && (s = (f = new File(FileOpenDialogEditor.this.text.getText())).getParent()) != null) {
                    lastDirectory = s;
                }
                if (FileOpenDialogEditor.this.descriptor.getAdvice() == Argument.Advice.DIRECTORY) {
                    dialog = new DirectoryDialog(FileOpenDialogEditor.this.getShell());
                    if (lastDirectory != null && lastDirectory.length() > 0) {
                        dialog.setFilterPath(lastDirectory);
                    } else {
                        dialog.setFilterPath(System.getProperty("user.home"));
                    }
                    String selectedDirectory = dialog.open();
                    if (selectedDirectory != null) {
                        prefs.setValue(LAST_DIRECTORY_KEY, selectedDirectory);
                        FileOpenDialogEditor.this.text.setText(selectedDirectory);
                    }
                } else {
                    dialog = new FileDialog(FileOpenDialogEditor.this.getShell(), FileOpenDialogEditor.this.descriptor.getAdvice() == Argument.Advice.SAVE ? 8192 : 4096);
                    dialog.setText(Messages.FileOpenDialogEditor_ChooseFile);
                    if (lastDirectory != null && lastDirectory.length() > 0) {
                        dialog.setFilterPath(lastDirectory);
                    } else {
                        dialog.setFilterPath(System.getProperty("user.home"));
                    }
                    dialog.open();
                    String[] names = dialog.getFileNames();
                    if (names != null && names.length > 0) {
                        String filterPath = dialog.getFilterPath();
                        prefs.setValue(LAST_DIRECTORY_KEY, filterPath);
                        FileOpenDialogEditor.this.text.setText(String.valueOf(filterPath) + File.separator + names[0]);
                    }
                }
            }
        });
    }

    protected void editingDone() {
        try {
            this.fireErrorEvent(null, this);
            String t = this.text.getText().trim();
            this.value = t.length() == 0 ? null : this.context.convertToValue(this.descriptor.getType(), this.descriptor.getAdvice(), t);
            this.fireValueChangedEvent(this.value, this);
        }
        catch (SnapshotException e) {
            this.fireErrorEvent(e.getMessage(), this);
        }
    }

    public void setValue(Object value) throws SnapshotException {
        this.value = value;
        this.text.setText(this.context.convertToString(this.descriptor.getType(), this.descriptor.getAdvice(), value));
    }

    public Object getValue() {
        return this.value;
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    private class FileOpenDialogEditorLayout
    extends Layout {
        private FileOpenDialogEditorLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = FileOpenDialogEditor.this.openButton.computeSize(-1, -1, force);
            if (FileOpenDialogEditor.this.text != null) {
                FileOpenDialogEditor.this.text.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            FileOpenDialogEditor.this.openButton.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = FileOpenDialogEditor.this.text.computeSize(-1, -1, force);
            Point buttonSize = FileOpenDialogEditor.this.openButton.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

