/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.editor;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mat.internal.snapshot.SnapshotQueryContext;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.GettingStartedWizard;
import org.eclipse.mat.ui.snapshot.ParseHeapDumpJob;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.ui.snapshot.views.SnapshotOutlinePage;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class HeapEditor
extends MultiPaneEditor
implements ISelectionProvider {
    private ISnapshotEditorInput snapshotInput;
    private SnapshotOutlinePage snapshotOutlinePage;
    private List<ISelectionChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    private ISelectionChangedListener proxy = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            HeapEditor.this.forwardSelectionChangedEvent(event);
        }
    };
    private Set<AbstractEditorPane> registered = new HashSet<AbstractEditorPane>();

    public IEditorInput getPaneEditorInput() {
        return this.snapshotInput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            this.snapshotInput = new SnapshotEditorInput(file.getLocation());
            this.setPartName(file.getName());
            return;
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            this.snapshotInput = new SnapshotEditorInput(path);
            this.setPartName(path.lastSegment());
            return;
        } else {
            if (!(input instanceof IURIEditorInput)) throw new PartInitException(MessageUtil.format((String)Messages.HeapEditor_UnsupportedEditorInput, (Object[])new Object[]{input.getClass().getName()}));
            URI uri = ((IURIEditorInput)input).getURI();
            if (!"file".equals(uri.getScheme())) throw new PartInitException(MessageUtil.format((String)Messages.HeapEditor_UnsupportedScheme, (Object[])new Object[]{uri.toASCIIString()}));
            Path path = new Path(uri.getPath());
            this.snapshotInput = new SnapshotEditorInput((IPath)path);
            this.setPartName(path.lastSegment());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.snapshotInput.hasSnapshot()) {
            SnapshotFactory.dispose((ISnapshot)this.snapshotInput.getSnapshot());
        }
        if (this.snapshotInput.hasBaseline()) {
            SnapshotFactory.dispose((ISnapshot)this.snapshotInput.getBaseline());
        }
        this.snapshotInput = null;
    }

    protected Job createInitializationJob() {
        return new ParseHeapDumpJob(this.snapshotInput.getPath()){

            protected void finished(ISnapshot snapshot) {
                ((SnapshotEditorInput)HeapEditor.this.snapshotInput).setSnapshot(snapshot);
                HeapEditor.this.setQueryContext((IQueryContext)new SnapshotQueryContext(snapshot));
            }
        };
    }

    protected void createInitialPanes() {
        this.addNewPage("OverviewPane", null);
        this.updateToolbar();
        Preferences prefs = MemoryAnalyserPlugin.getDefault().getPluginPreferences();
        boolean hideWizard = prefs.getBoolean("hideGettingStartedWizard");
        if (!hideWizard) {
            GettingStartedWizard wizard = new GettingStartedWizard(this);
            WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(false);
            dialog.create();
            dialog.open();
        }
    }

    public ISnapshotEditorInput getSnapshotInput() {
        return this.snapshotInput;
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.snapshotOutlinePage == null) {
                this.snapshotOutlinePage = new SnapshotOutlinePage.HeapEditorOutlinePage(this.getSnapshotInput());
            }
            return this.snapshotOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        AbstractEditorPane activeEditor = this.getActiveEditor();
        if (activeEditor instanceof ISelectionProvider) {
            return ((ISelectionProvider)activeEditor).getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    private void forwardSelectionChangedEvent(SelectionChangedEvent event) {
        ArrayList<ISelectionChangedListener> l = new ArrayList<ISelectionChangedListener>(this.listeners);
        for (ISelectionChangedListener listener : l) {
            listener.selectionChanged(event);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        AbstractEditorPane activeEditor = this.getEditor(newPageIndex);
        if (activeEditor != null) {
            SelectionChangedEvent event = null;
            if (activeEditor instanceof ISelectionProvider) {
                ISelectionProvider provider = (ISelectionProvider)activeEditor;
                if (this.registered.add(activeEditor)) {
                    provider.addSelectionChangedListener(this.proxy);
                }
                ISelection selection = provider.getSelection();
                event = new SelectionChangedEvent(provider, selection);
            }
            if (event != null) {
                this.forwardSelectionChangedEvent(event);
            }
        }
    }

    protected void disposePart(IWorkbenchPart part) {
        this.registered.remove(part);
        super.disposePart(part);
    }

    class SnapshotEditorInput
    implements ISnapshotEditorInput {
        private IPath path;
        private ISnapshot snapshot;
        private ISnapshot baseline;
        List<ISnapshotEditorInput.IChangeListener> listeners = new ArrayList<ISnapshotEditorInput.IChangeListener>();

        public SnapshotEditorInput(IPath osFilename) {
            this.path = osFilename;
        }

        public IPath getPath() {
            return this.path;
        }

        public ISnapshot getSnapshot() {
            return this.snapshot;
        }

        public void setSnapshot(ISnapshot snapshot) {
            this.snapshot = snapshot;
            ArrayList<ISnapshotEditorInput.IChangeListener> listeners = new ArrayList<ISnapshotEditorInput.IChangeListener>(this.listeners);
            for (ISnapshotEditorInput.IChangeListener listener : listeners) {
                listener.onSnapshotLoaded(snapshot);
            }
        }

        public boolean hasSnapshot() {
            return this.snapshot != null;
        }

        public ISnapshot getBaseline() {
            return this.baseline;
        }

        public synchronized void setBaseline(ISnapshot snapshot) {
            if (this.baseline != null) {
                SnapshotFactory.dispose((ISnapshot)this.baseline);
            }
            this.baseline = snapshot;
            ArrayList<ISnapshotEditorInput.IChangeListener> listeners = new ArrayList<ISnapshotEditorInput.IChangeListener>(this.listeners);
            for (ISnapshotEditorInput.IChangeListener listener : listeners) {
                listener.onBaselineLoaded(snapshot);
            }
        }

        public boolean hasBaseline() {
            return this.baseline != null;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.path.toOSString();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.path.toOSString();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public void addChangeListener(ISnapshotEditorInput.IChangeListener listener) {
            this.listeners.add(listener);
        }

        public void removeChangeListener(ISnapshotEditorInput.IChangeListener listener) {
            this.listeners.remove(listener);
        }

        public boolean equals(Object obj) {
            return obj instanceof SnapshotEditorInput && ((SnapshotEditorInput)obj).path.equals((Object)this.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

