/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mat.inspections.osgi.BundleRegistryQuery;
import org.eclipse.mat.inspections.osgi.model.OSGiModel;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.ui.PlatformUI;

public class BundlesPane
extends QueryResultPane {
    private BundleRegistryQuery.Grouping groupBy;
    private OSGiModel model;

    public void initWithArgument(Object argument) {
        QueryResult queryResult = (QueryResult)argument;
        BundleRegistryQuery.BundleTreeResult tree = (BundleRegistryQuery.BundleTreeResult)queryResult.getSubject();
        this.groupBy = tree.getGroupBy();
        this.model = tree.getModel();
        super.initWithArgument(argument);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        this.addGroupingOptions(manager);
        super.contributeToToolBar(manager);
    }

    private void addGroupingOptions(IToolBarManager manager) {
        EasyToolBarDropDown groupingAction = new EasyToolBarDropDown(Messages.BundlesPane_GroupBy, MemoryAnalyserPlugin.getImageDescriptor("icons/grouping.gif"), this){

            public void contribute(PopupMenu menu) {
                BundleRegistryQuery.Grouping[] groupingArray = BundleRegistryQuery.Grouping.values();
                int n = groupingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleRegistryQuery.Grouping choice = groupingArray[n2];
                    TopLevelAction action = new TopLevelAction(choice);
                    action.setEnabled(choice != BundlesPane.this.groupBy);
                    action.setChecked(choice == BundlesPane.this.groupBy);
                    menu.add(action);
                    ++n2;
                }
            }
        };
        manager.add((IAction)groupingAction);
    }

    private class TopLevelAction
    extends Action {
        private BundleRegistryQuery.Grouping target;

        public TopLevelAction(BundleRegistryQuery.Grouping topLevelBy) {
            super(topLevelBy.toString(), 2);
            this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(topLevelBy.getIcon()));
            this.target = topLevelBy;
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            AbstractPaneJob job = new AbstractPaneJob(this.getText(), BundlesPane.this){

                protected IStatus doRun(IProgressMonitor monitor) {
                    BundleRegistryQuery.BundleTreeResult tree = null;
                    switch (TopLevelAction.this.target) {
                        case NONE: {
                            tree = BundleRegistryQuery.Factory.create((OSGiModel)BundlesPane.this.model);
                            break;
                        }
                        case BY_SERVICE: {
                            tree = BundleRegistryQuery.Factory.servicesOnTop((OSGiModel)BundlesPane.this.model);
                            break;
                        }
                        case BY_EXTENSION_POINT: {
                            tree = BundleRegistryQuery.Factory.extensionPointsOnTop((OSGiModel)BundlesPane.this.model);
                        }
                    }
                    final QueryResult queryResult = new QueryResult(null, "bundle_registry -groupBy " + TopLevelAction.this.target.name(), (IResult)tree);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            BundlesPane.this.deactivateViewer();
                            BundlesPane.this.groupBy = TopLevelAction.this.target;
                            RefinedResultViewer v = BundlesPane.this.createViewer(queryResult);
                            BundlesPane.this.activateViewer(v);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

