/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.ui.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class Copy {
    protected Control control;
    protected Item[] selection;
    private Map<Integer, Integer> columnLengths = new HashMap<Integer, Integer>();

    protected abstract void append(String var1);

    protected abstract void done();

    public static void copyToClipboard(Control control) {
        TableItem[] selection = control instanceof Table ? ((Table)control).getSelection() : ((Tree)control).getSelection();
        new CopyToClipboard(control, (Item[])selection).doCopy();
    }

    public static void exportToTxtFile(Control control, String fileName) {
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(new FileWriter(fileName));
                new ExportToFile(control, null, writer).doCopy();
            }
            catch (IOException e) {
                throw new RuntimeException(Messages.Copy_ErrorInExport, e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private Copy(Control control, Item[] selection) {
        this.control = control;
        this.selection = selection != null && selection.length > 0 ? selection : null;
    }

    protected void doCopy() {
        int numberOfColumns = this.getColumnCount();
        Object[] items = this.selection != null ? this.selection : (this.control instanceof Table ? ((Table)this.control).getItems() : ((Tree)this.control).getItems());
        Item[] columns = this.getColumns(this.control);
        if (numberOfColumns == 0) {
            this.copySimpleStructure(items);
        } else {
            int columnIndex = 0;
            while (columnIndex < numberOfColumns) {
                this.getColumnLength(items, columns, columnIndex);
                ++columnIndex;
            }
            int i = 0;
            while (i < numberOfColumns) {
                if (i == 0) {
                    this.append(Copy.align(columns[i].getText(), true, this.columnLengths.get(0)));
                } else {
                    this.append("|" + Copy.align(columns[i].getText(), false, this.columnLengths.get(i)));
                }
                ++i;
            }
            this.append("\r\n");
            String dashedLine = this.getDashedLine(numberOfColumns);
            this.append(String.valueOf(dashedLine) + "\r\n");
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                boolean addLineBreak = true;
                int columnIndex2 = 0;
                while (columnIndex2 < numberOfColumns) {
                    String value = "";
                    if (item instanceof TableItem) {
                        value = ((TableItem)item).getText(columnIndex2);
                    } else if (item instanceof TreeItem && this.toPrint((TreeItem)item)) {
                        value = ((TreeItem)item).getText(columnIndex2);
                    } else if (item instanceof TreeItem && !this.toPrint((TreeItem)item)) {
                        addLineBreak = false;
                        break;
                    }
                    String[] stringArray = Filter.FILTER_TYPES;
                    int n3 = Filter.FILTER_TYPES.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filterName = stringArray[n4];
                        if (value.equals(filterName)) {
                            value = "";
                        }
                        ++n4;
                    }
                    if (columnIndex2 == 0) {
                        if (numberOfColumns == 1) {
                            this.append(value);
                        } else {
                            this.append(Copy.align(value, true, this.columnLengths.get(0)));
                        }
                    } else {
                        this.append("|" + Copy.align(value, false, this.columnLengths.get(columnIndex2)));
                    }
                    ++columnIndex2;
                }
                if (addLineBreak) {
                    this.append("\r\n");
                }
                if (item instanceof TreeItem && ((TreeItem)item).getExpanded() && this.toPrint((TreeItem)item)) {
                    this.addNextLineToClipboard(new StringBuilder(), (TreeItem)item, numberOfColumns, this.columnLengths.get(0));
                }
                ++n2;
            }
            this.columnLengths.clear();
            this.append(String.valueOf(dashedLine) + "\r\n");
        }
        this.done();
    }

    /*
     * Unable to fully structure code
     */
    private void copySimpleStructure(Object[] items) {
        var5_2 = items;
        var4_3 = items.length;
        var3_4 = 0;
        while (var3_4 < var4_3) {
            block6: {
                block5: {
                    item = var5_2[var3_4];
                    addLineBreak = true;
                    value = "";
                    if (!(item instanceof TableItem)) break block5;
                    value = ((TableItem)item).getText();
                    ** GOTO lbl-1000
                }
                if (!(item instanceof TreeItem) || !this.toPrint((TreeItem)item)) break block6;
                value = ((TreeItem)item).getText();
                ** GOTO lbl-1000
            }
            if (item instanceof TreeItem && !this.toPrint((TreeItem)item)) {
                addLineBreak = false;
            } else lbl-1000:
            // 3 sources

            {
                this.append(value);
                if (addLineBreak) {
                    this.append("\r\n");
                }
                if (item instanceof TreeItem && ((TreeItem)item).getExpanded() && this.toPrint((TreeItem)item)) {
                    this.addNextLineToClipboard(new StringBuilder(), (TreeItem)item, 0, ((TreeItem)item).getText().length());
                }
            }
            ++var3_4;
        }
    }

    private void addNextLineToClipboard(StringBuilder level, TreeItem item, int numberOfColumns, int length) {
        TreeItem[] children = item.getItems();
        int j = 0;
        while (j < children.length) {
            level = this.getLevel(level, children.length, j);
            if (this.selection == null || !this.skip(children[j])) {
                if (numberOfColumns < 2) {
                    this.append(level + children[j].getText());
                } else {
                    this.append(level + Copy.align(children[j].getText(0), true, length - level.length()));
                    int i = 1;
                    while (i < numberOfColumns) {
                        this.append("|" + Copy.align(children[j].getText(i), false, this.columnLengths.get(i)));
                        ++i;
                    }
                }
                this.append("\r\n");
                if (children[j].getExpanded()) {
                    this.addNextLineToClipboard(level, children[j], numberOfColumns, length);
                }
                if (level.length() >= 3) {
                    level.delete(level.length() - 3, level.length());
                }
            }
            ++j;
        }
    }

    private Item[] getColumns(Control control) {
        if (control instanceof Table) {
            return ((Table)control).getColumns();
        }
        return ((Tree)control).getColumns();
    }

    private int getColumnCount() {
        if (this.control instanceof Table) {
            return ((Table)this.control).getColumnCount();
        }
        if (this.control instanceof Tree) {
            return ((Tree)this.control).getColumnCount();
        }
        return 0;
    }

    private static String align(String s, boolean left, int length) {
        StringBuilder buf = new StringBuilder(length);
        if (s != null) {
            if (s.length() > length) {
                return s;
            }
            int blanks = length - s.length();
            if (left) {
                buf.append(s);
            }
            int i = 0;
            while (i < blanks) {
                buf.append(' ');
                ++i;
            }
            if (!left) {
                buf.append(' ');
                buf.append(s);
                buf.append(' ');
            }
        } else {
            int i = 0;
            while (i < length) {
                buf.append(' ');
                ++i;
            }
            if (!left) {
                buf.append(' ').append(' ');
            }
        }
        return buf.toString();
    }

    private String getDashedLine(int numberOfColumns) {
        StringBuilder dashes = new StringBuilder();
        int dashesLength = 0;
        int i = 0;
        while (i < numberOfColumns) {
            dashesLength += this.columnLengths.get(i).intValue();
            ++i;
        }
        i = 0;
        while (i < dashesLength + numberOfColumns * 2) {
            dashes.append('-');
            ++i;
        }
        return dashes.toString();
    }

    private int getColumnLength(Object[] items, Item[] columns, int columnNumber) {
        int lengthToCompare = 0;
        String header = columns[columnNumber].getText();
        int length = header != null ? header.length() : 0;
        int i = 0;
        while (i < items.length) {
            lengthToCompare = items[i] instanceof TableItem ? ((TableItem)items[i]).getText(columnNumber).length() : ((TreeItem)items[i]).getText(columnNumber).length();
            if (lengthToCompare > length) {
                length = lengthToCompare;
            }
            if (items[i] instanceof TreeItem && ((TreeItem)items[i]).getExpanded()) {
                lengthToCompare = columnNumber == 0 ? this.compare((TreeItem)items[i], length, new StringBuilder()) : this.getOtherColumnLength((TreeItem)items[i], length, columnNumber);
            }
            if (lengthToCompare > length) {
                length = lengthToCompare;
            }
            ++i;
        }
        if (!this.columnLengths.containsKey(columnNumber) || this.columnLengths.containsKey(columnNumber) && this.columnLengths.get(columnNumber) < length) {
            this.columnLengths.put(columnNumber, length);
        }
        return length;
    }

    private int getOtherColumnLength(TreeItem item, int length, int columnNumber) {
        int lengthToCompare = 0;
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            if (this.selection == null || !this.skip(children[i])) {
                String columnText = children[i].getText(columnNumber);
                if (columnText != null) {
                    lengthToCompare = columnText.length();
                }
                if (lengthToCompare > length) {
                    length = lengthToCompare;
                }
                if (children[i].getExpanded() && (lengthToCompare = this.getOtherColumnLength(children[i], length, columnNumber)) > length) {
                    length = lengthToCompare;
                }
            }
            ++i;
        }
        return length;
    }

    private int compare(TreeItem item, int length, StringBuilder level) {
        int lengthToCompare = 0;
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            if (this.selection == null || !this.skip(children[i])) {
                level = this.getLevel(level, children.length, i);
                lengthToCompare = children[i].getText(0).length() + level.length();
                if (lengthToCompare > length) {
                    length = lengthToCompare;
                }
                if (children[i].getExpanded() && (lengthToCompare = this.compare(children[i], length, level)) > length) {
                    length = lengthToCompare;
                }
                if (level.length() >= 3) {
                    level.delete(level.length() - 3, level.length());
                }
            }
            ++i;
        }
        return length;
    }

    private boolean toPrint(TreeItem item) {
        TreeItem[] selection;
        if (this.selection == null) {
            return true;
        }
        TreeItem[] treeItemArray = selection = (TreeItem[])this.selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.equals(item.getParentItem())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean skip(TreeItem item) {
        TreeItem[] selection;
        TreeItem[] treeItemArray = selection = (TreeItem[])this.selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.equals(item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private StringBuilder getLevel(StringBuilder level, int length, int counter) {
        int k = level.indexOf("'-");
        if (k != -1) {
            level.replace(k, k + 2, "  ");
        } else {
            k = level.indexOf("|-");
            if (k != -1) {
                level.replace(k + 1, k + 2, " ");
            }
        }
        if (counter == length - 1) {
            level.append('\'');
        } else {
            level.append('|');
        }
        level.append("- ");
        return level;
    }

    /* synthetic */ Copy(Control control, Item[] itemArray, Copy copy) {
        this(control, itemArray);
    }

    private static class CopyToClipboard
    extends Copy {
        private StringBuilder buffer = new StringBuilder();

        private CopyToClipboard(Control control, Item[] selection) {
            super(control, selection, null);
        }

        protected void append(String string) {
            this.buffer.append(string);
        }

        protected void done() {
            Clipboard clipboard = new Clipboard(this.control.getDisplay());
            clipboard.setContents(new Object[]{this.buffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private static class ExportToFile
    extends Copy {
        private PrintWriter writer;

        public ExportToFile(Control control, Item[] selection, PrintWriter writer) {
            super(control, selection, null);
            this.writer = writer;
        }

        protected void append(String string) {
            this.writer.write(string);
        }

        protected void done() {
            this.writer.flush();
        }
    }
}

