/**
 * Copyright (c) 2003,2009 Craig Setera and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Craig Setera (EclipseME) - Initial implementation
 *     Diego Sandin (Motorola)  - Refactoring package name to follow eclipse 
 *                                standards
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.util.List;

import org.eclipse.mtj.core.sdk.device.IDevice;

/**
 * This interface provides a means to communicate a set of devices that are
 * found while searching using the DeviceFinder. Implementors can choose to use
 * these method for update of user interface or other functions as necessary.
 * <p>
 * <strong>EXPERIMENTAL</strong>. This class or interface has been added as part
 * of a work in progress. There is no guarantee that this API will work or that
 * it will remain the same. Please do not use this API without consulting with
 * the MTJ team.
 * </p>
 * 
 * @author Craig Setera
 */
public interface IFoundDevicesList {

    /**
     * Add the specified devices to the list of found devices.
     * 
     * @param devices
     */
    public void addDevices(List<IDevice> devices);

    /**
     * Return all devices added to the list.
     * 
     * @return
     */
    public List<IDevice> getDevices();
}
