/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.IDeviceFinder;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.symbol.ISymbolSetFactory;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistry;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.preprocessor.PreprocessedSourceMapper;
import org.eclipse.mtj.internal.core.build.preverifier.ProguardPreverifier;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapper;
import org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapperAccess;
import org.eclipse.mtj.internal.core.project.midp.MetaData;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.sdk.device.DeviceFinder;
import org.eclipse.mtj.internal.core.sdk.device.DeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPLibrary;
import org.eclipse.mtj.internal.core.sdk.device.midp.UEILibraryImporter;
import org.eclipse.mtj.internal.core.symbol.SymbolSetFactory;
import org.eclipse.mtj.internal.core.symbol.SymbolSetRegistry;
import org.eclipse.mtj.internal.core.util.ClasspathChangeMonitor;
import org.eclipse.mtj.internal.core.util.MTJBuildPropertiesResourceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MTJCore
extends Plugin {
    private static MTJCore plugin;

    public static IMetaData createMetaData(IProject project, ProjectType projectType) {
        switch (projectType) {
            case MIDLET_SUITE: {
                return new MetaData(project);
            }
        }
        return null;
    }

    public static IAPI createNewAPI(ProjectType projectType) {
        switch (projectType) {
            case MIDLET_SUITE: {
                return new MIDPAPI();
            }
        }
        return null;
    }

    public static IDeviceClasspath createNewDeviceClasspath() {
        return new DeviceClasspath();
    }

    public static ILibrary createNewLibrary(ProjectType projectType) {
        switch (projectType) {
            case MIDLET_SUITE: {
                return new MIDPLibrary();
            }
        }
        return null;
    }

    public static IPreverifier createPreverifier(String preverifierType, Object param) throws CoreException {
        IPreverifier preverifier = null;
        if (preverifierType.equals("org.eclipse.mtj.preverifier.standard")) {
            if (param instanceof File) {
                preverifier = StandardPreverifierFactory.createPreverifier((File)param);
            }
        } else if (preverifierType.equals("org.eclipse.mtj.preverifier.proguard")) {
            preverifier = ProguardPreverifier.getInstance();
        }
        return preverifier;
    }

    public static IMTJProject geMTJProject(IProject project) {
        if (MidletSuiteFactory.isMidletSuiteProject(project)) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IMidletSuiteProject suite = MidletSuiteFactory.getMidletSuiteProject(javaProject);
            return suite;
        }
        return null;
    }

    public static String getDeploymentDirectoryName() {
        return PreferenceAccessor.instance.getString("deployment_dir");
    }

    public static IDeviceFinder getDeviceFinder() {
        return DeviceFinder.getInstance();
    }

    public static IDeviceRegistry getDeviceRegistry() {
        return DeviceRegistry.getInstance();
    }

    public static IDeviceMatchCache getDeviceMatchCache() {
        return DeviceMatchCache.getInstance();
    }

    public static ILibraryImporter getLibraryImporter(String type) {
        UEILibraryImporter result = null;
        if (type.equals("org.eclipse.mtj.libraryimporter.uei")) {
            result = new UEILibraryImporter();
        }
        return result;
    }

    public static MTJCore getMTJCore() {
        return plugin;
    }

    public static String getMTJCoreVersion() {
        Bundle bundle = MTJCore.getMTJCore().getBundle();
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public static File getProguardJarFile() {
        String proguardDirPref = PreferenceAccessor.instance.getString("proguard_dir");
        File proguardDir = new File(proguardDirPref);
        File proguardLibDir = new File(proguardDir, "lib");
        File proguardJar = new File(proguardLibDir, "proguard.jar");
        return proguardJar;
    }

    public static InputStream getResourceAsStream(IPath path) {
        InputStream stream = null;
        URL url = FileLocator.find((Bundle)MTJCore.getMTJCore().getBundle(), (IPath)path, null);
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stream;
    }

    public static String getResourcesDirectoryName() {
        return PreferenceAccessor.instance.getString("resources_dir");
    }

    public static ISymbolSetFactory getSymbolSetFactory() {
        return SymbolSetFactory.getInstance();
    }

    public static ISymbolSetRegistry getSymbolSetRegistry() {
        return SymbolSetRegistry.getInstance();
    }

    public static String getVerifiedOutputDirectoryName() {
        return PreferenceAccessor.instance.getString("verified_dir");
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public MTJCore() {
        if (plugin == null) {
            plugin = this;
        }
        MTJCore.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                switch (event.getType()) {
                    case 4: {
                        IProject project;
                        IMTJProject meProject;
                        IResource resource = event.getResource();
                        if (!(resource instanceof IProject) || (meProject = MidletSuiteFactory.getMidletSuiteProject((project = (IProject)resource).getName())) == null) break;
                        MidletSuiteFactory.removeMidletSuiteProject(meProject.getJavaProject());
                    }
                }
            }
        });
        MTJCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)new MTJBuildPropertiesResourceListener(), 1);
        MTJCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)ClasspathChangeMonitor.getInstance(), 1);
    }

    public static String getPluginId() {
        return MTJCore.getMTJCore().getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SourceMapperAccess.setSourceMapper((SourceMapper)new PreprocessedSourceMapper());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

