/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.build.BuildHookInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildHooksRegistry
implements IRegistryChangeListener {
    private static final String EXT_ID = "org.eclipse.mtj.core.mtjbuildhook";
    private static final String EXT_MTJ_BUILD_HOOK = "mtjbuildhook";
    private static BuildHooksRegistry instance;
    private List<BuildHookInfo> hooks;

    public static synchronized BuildHooksRegistry getInstance() {
        if (instance == null) {
            instance = new BuildHooksRegistry();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)instance);
        }
        return instance;
    }

    private BuildHooksRegistry() {
        IExtensionRegistry registry = null;
        IConfigurationElement[] extensions = null;
        BuildHookInfo hooksInfo = null;
        this.hooks = new ArrayList<BuildHookInfo>();
        registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            hooksInfo = new BuildHookInfo(extension);
            this.hooks.add(hooksInfo);
            ++n2;
        }
    }

    public List<BuildHookInfo> getBuildHooks() {
        ArrayList<BuildHookInfo> result = new ArrayList<BuildHookInfo>();
        result.addAll(this.hooks);
        return result;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        String pluginId = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IExtensionDelta[] deltas = event.getExtensionDeltas(pluginId, EXT_MTJ_BUILD_HOOK);
        int i = 0;
        while (i < deltas.length) {
            BuildHookInfo hooksInfo;
            IConfigurationElement configurationElement;
            int n;
            int n2;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] configurationElements;
            if (deltas[i].getKind() == 1) {
                iConfigurationElementArray = configurationElements = deltas[i].getExtension().getConfigurationElements();
                n2 = configurationElements.length;
                n = 0;
                while (n < n2) {
                    configurationElement = iConfigurationElementArray[n];
                    hooksInfo = new BuildHookInfo(configurationElement);
                    this.hooks.add(hooksInfo);
                    ++n;
                }
            } else {
                iConfigurationElementArray = configurationElements = deltas[i].getExtension().getConfigurationElements();
                n2 = configurationElements.length;
                n = 0;
                while (n < n2) {
                    configurationElement = iConfigurationElementArray[n];
                    hooksInfo = new BuildHookInfo(configurationElement);
                    int j = 0;
                    while (j < this.hooks.size()) {
                        if (this.hooks.get(j).getHookId().equals(hooksInfo.getHookId())) {
                            this.hooks.remove(j);
                            break;
                        }
                        ++j;
                    }
                    ++n;
                }
            }
            ++i;
        }
    }
}

