/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.build.BuildHookInfo;
import org.eclipse.mtj.internal.core.build.BuildHooksRegistry;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;

public class BuildStateMachine {
    private static Map<IMTJProject, BuildStateMachine> map;
    private List<IStatus> buildStatuses = new ArrayList<IStatus>();
    private MTJBuildState currentState;
    private IMTJProject mtjProject;
    private Object lock;

    public static synchronized BuildStateMachine getInstance(IMTJProject mtjProject) {
        BuildStateMachine stateMachine = null;
        if (map == null) {
            map = new HashMap<IMTJProject, BuildStateMachine>();
        }
        if ((stateMachine = map.get(mtjProject)) == null) {
            stateMachine = new BuildStateMachine(mtjProject);
            map.put(mtjProject, stateMachine);
        }
        return stateMachine;
    }

    private BuildStateMachine(IMTJProject mtjProject) {
        this.mtjProject = mtjProject;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(IProgressMonitor monitor) throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            this.currentState = null;
        }
        this.buildStatuses.clear();
        this.changeState(MTJBuildState.PRE_BUILD, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeState(MTJBuildState state, IProgressMonitor monitor) throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == null && state != MTJBuildState.PRE_BUILD) {
                throw new CoreException(MTJStatusHandler.newStatus(4, 999, "Build state machine has not been initialized."));
            }
            if (this.currentState == state) {
                return;
            }
            this.currentState = state;
        }
        List<BuildHookInfo> hooks = BuildHooksRegistry.getInstance().getBuildHooks();
        for (BuildHookInfo hook : hooks) {
            try {
                hook.getHook().buildStateChanged(this.mtjProject, this.currentState, monitor);
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.currentState == MTJBuildState.POST_BUILD && this.buildStatuses.size() > 0) {
                for (IStatus buildStatus : this.buildStatuses) {
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(buildStatus);
                    if (handler == null) continue;
                    handler.handleStatus(buildStatus, (Object)this);
                }
            }
        }
    }

    public MTJBuildState getCurrentState() {
        return this.currentState;
    }

    private void handleException(CoreException e) throws CoreException {
        IStatus status = e.getStatus();
        if (status.getSeverity() == 4) {
            throw e;
        }
        this.buildStatuses.add(status);
    }
}

