/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntBuildFilesFilterState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntBuildTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntCleanTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntGeneratePropertiesState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntInitTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntPackageTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntPreprocessTaskState;
import org.eclipse.mtj.internal.core.build.export.states.CreateAntTaskStateTransition;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateMachineEvent;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AntennaBuildExport {
    public static final String PROGUARD_HOME = "wtk.proguard.home";
    public static final String WTK_CLDC_VERSION = "wtk.cldc.version";
    public static final String WTK_MIDP_VERSION = "wtk.midp.version";
    public static final String ANTENNA_LIB = "antenna.lib";
    public static final String MTJ_BUILD_PROPERTIES = "mtj-build.properties";
    public static final String WTK_HOME = "wtk.home";
    public static final String DO_OBFUSCATE = "do-obfuscate";
    public static final String DO_AUTOVERSION = "do-autoversion";
    public static final String DEFAULT_BUILD_XML = "mtj-build.xml";
    public static final String DEFAULT_BUILD_FOLDER = "mtj-build";
    private IMidletSuiteProject suiteProject;
    private StateMachine stateMachine;
    private String buildFileName;
    private String buildFolderName;
    private boolean isLocalization;

    public AntennaBuildExport(IMidletSuiteProject _suiteProject, String file, String folder) {
        if (_suiteProject == null) {
            throw new IllegalArgumentException(Messages.NewAntennaBuildExport_InvalidSuiteProject);
        }
        this.suiteProject = _suiteProject;
        this.buildFileName = file;
        this.buildFolderName = folder;
    }

    public void doExport(IProgressMonitor monitor) throws AntennaExportException {
        this.stateMachine = new StateMachine();
        Document document = this.createNewDocument();
        if (document == null) {
            throw new AntennaExportException(Messages.NewAntennaBuildExport_UnableToCreateXMLDoc);
        }
        this.isLocalization = false;
        try {
            this.isLocalization = this.suiteProject.getProject().hasNature("org.eclipse.mtj.core.l10nNature");
        }
        catch (CoreException coreException) {}
        this.createAntExportStates(this.stateMachine, document);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            IFile fileTask;
            InputStream stream;
            IFolder buildTask;
            IProject project = this.suiteProject.getProject();
            IFolder build = project.getFolder(this.buildFolderName);
            if (!build.exists()) {
                build.create(true, true, monitor);
            }
            if (!(buildTask = project.getFolder(String.valueOf(this.buildFolderName) + "/custom-tasks")).exists()) {
                buildTask.create(true, true, monitor);
            }
            if (this.isLocalization) {
                stream = MTJCore.getResourceAsStream((IPath)new Path("templates/GeneratingProperties.class.template"));
                fileTask = buildTask.getFile("GeneratingProperties.class");
                if (!fileTask.exists()) {
                    fileTask.create(stream, true, monitor);
                }
            }
            stream = MTJCore.getResourceAsStream((IPath)new Path("templates/BuildFilesFilter.class.template"));
            fileTask = buildTask.getFile("BuildFilesFilter.class");
            if (!fileTask.exists()) {
                fileTask.create(stream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            this.stateMachine.start();
            IFile file = build.getFile(this.buildFileName);
            XMLUtils.writeDocument(file.getLocation().toFile(), document);
            this.writeBuildProperties(build.getFile(MTJ_BUILD_PROPERTIES));
            build.refreshLocal(2, monitor);
        }
        catch (Exception e) {
            MTJLogger.log(4, e);
        }
    }

    private static String extractVersion(String str) {
        String[] split = str.split("-");
        if (split.length == 2) {
            str = split[1];
        }
        return str;
    }

    private void writeBuildProperties(IFile file) throws IOException {
        IApplicationDescriptor jad = this.suiteProject.getApplicationDescriptor();
        PreferenceAccessor pref = PreferenceAccessor.instance;
        Properties properties = new Properties();
        properties.put(DO_AUTOVERSION, "false");
        properties.put(DO_OBFUSCATE, "false");
        properties.put(ANTENNA_LIB, pref.getString("antenna_jar"));
        properties.put(WTK_HOME, pref.getString("wtk_root"));
        properties.put(WTK_CLDC_VERSION, AntennaBuildExport.extractVersion(jad.getMicroEditionConfiguration()));
        properties.put(WTK_MIDP_VERSION, AntennaBuildExport.extractVersion(jad.getMicroEditionProfile()));
        String proguardDir = pref.getString("proguard_dir");
        if (proguardDir != null && proguardDir.length() > 0) {
            properties.put(PROGUARD_HOME, proguardDir);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file.getLocation().toFile());
            properties.store(out, Messages.NewAntennaBuildExport_comment);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void createAntExportStates(StateMachine _stateMachine, Document _document) {
        AbstractCreateAntTaskState state1 = null;
        AbstractCreateAntTaskState state2 = null;
        CreateAntGeneratePropertiesState state3 = null;
        Element root = this.createProjectElement(_document, "build-all");
        this.setupDefaultTarget(_document, root);
        this.setupAntenna(_document, root);
        if (this.isLocalization) {
            this.setupGeneratingProperties(_document, root);
        }
        this.setupBuildFilesFilter(_document, root);
        state1 = new CreateAntCleanTaskState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName);
        this.stateMachine.addState(state1);
        this.stateMachine.setInitialState(state1);
        state2 = new CreateAntInitTaskState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName);
        state2.setDependencies("clean");
        this.stateMachine.addState(state2);
        state1.addTransition(new CreateAntTaskStateTransition(state1, state2));
        boolean isPreprocessing = false;
        try {
            isPreprocessing = this.suiteProject.getProject().hasNature("org.eclipse.mtj.core.preprocessingNature");
        }
        catch (CoreException coreException) {}
        if (this.isLocalization) {
            state3 = new CreateAntGeneratePropertiesState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName);
            state3.setDependencies("init");
            this.stateMachine.addState(state3);
            state2.addTransition(new CreateAntTaskStateTransition(state2, state3));
            state1 = isPreprocessing ? new CreateAntPreprocessTaskState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName) : new CreateAntBuildFilesFilterState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName);
            state1.setDependencies("generate-resources");
            state3.addTransition(new CreateAntTaskStateTransition(state3, state1));
        } else {
            state1 = isPreprocessing ? new CreateAntPreprocessTaskState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName) : new CreateAntBuildFilesFilterState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName);
            state1.setDependencies("init");
            state2.addTransition(new CreateAntTaskStateTransition(state2, state1));
        }
        state2 = new CreateAntBuildTaskState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName);
        if (isPreprocessing) {
            state2.setDependencies("preprocess");
        } else {
            state2.setDependencies("buildFilesFilter");
        }
        state1.addTransition(new CreateAntTaskStateTransition(state1, state2));
        state1 = new CreateAntPackageTaskState(this.stateMachine, this.suiteProject, _document, this.buildFolderName, this.buildFileName);
        state1.setDependencies("build");
        state2.addTransition(new CreateAntTaskStateTransition(state2, state1));
    }

    private void setupDefaultTarget(Document _document, Element root) {
        Element buildAll = XMLUtils.createTargetElement(_document, root, "build-all", "clean-all");
        MTJRuntimeList runtimeList = this.suiteProject.getRuntimeList();
        for (MTJRuntime runtime : runtimeList) {
            String configName = runtime.getName().replace(" ", "_");
            Element antCall = _document.createElement("antcall");
            antCall.setAttribute("target", NLS.bind((String)"package-{0}", (Object)configName));
            buildAll.appendChild(antCall);
        }
    }

    private void setupAntenna(Document _document, Element root) {
        Element taskdef = _document.createElement("taskdef");
        taskdef.setAttribute("resource", "antenna.properties");
        taskdef.setAttribute("classpath", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", ANTENNA_LIB, "}"}));
        root.appendChild(taskdef);
        Element property = _document.createElement("property");
        property.setAttribute("file", NLS.bind((String)"{0}/{1}", (Object[])new String[]{this.buildFolderName, MTJ_BUILD_PROPERTIES}));
        root.appendChild(property);
    }

    private void setupGeneratingProperties(Document _document, Element root) {
        Element taskdef = _document.createElement("taskdef");
        taskdef.setAttribute("classpath", String.valueOf(this.buildFolderName) + "/custom-tasks");
        taskdef.setAttribute("classname", "GeneratingProperties");
        taskdef.setAttribute("name", "generatingProperties");
        root.appendChild(taskdef);
    }

    private void setupBuildFilesFilter(Document _document, Element root) {
        Element taskdef = _document.createElement("taskdef");
        taskdef.setAttribute("classpath", String.valueOf(this.buildFolderName) + "/custom-tasks");
        taskdef.setAttribute("classname", "BuildFilesFilter");
        taskdef.setAttribute("name", "buildFilesFilter");
        root.appendChild(taskdef);
    }

    private Element createProjectElement(Document _document, String _target) {
        Element root = _document.createElement("project");
        _document.appendChild(root);
        root.setAttribute("name", this.suiteProject.getProject().getName());
        root.setAttribute("default", _target);
        root.setAttribute("basedir", "..");
        return root;
    }

    private Document createNewDocument() {
        Document result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static class CreateAntTaskDoneEvent
    extends AbstractStateMachineEvent {
    }
}

