/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.LibraryCollector;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntBuildTaskState
extends AbstractCreateAntTaskState {
    public CreateAntBuildTaskState(StateMachine machine, IMidletSuiteProject project, Document _document, String buildFolder, String buildFile) {
        super(machine, project, _document, buildFolder, buildFile);
    }

    protected void onEnter(MTJRuntime runtime) throws AntennaExportException {
        Document document = this.getDocument();
        Element root = document.getDocumentElement();
        String configName = this.getFormatedName(runtime.getName());
        Element build = XMLUtils.createTargetElement(document, root, NLS.bind((String)"build-{0}", (Object)configName), this.getDependencies(runtime));
        Set<IProject> requiredProjects = this.getRequiredProjects(this.getMidletSuiteProject().getProject());
        if (requiredProjects.size() > 0) {
            Element copy = document.createElement("copy");
            build.appendChild(copy);
            Object[] values = new String[]{this.getBuildFolder(), configName, this.getFormatedName(this.getMidletSuiteProject().getProject().getName())};
            copy.setAttribute("todir", NLS.bind((String)"{0}/{1}/{2}/resources/", (Object[])values));
            for (IProject required : requiredProjects) {
                Element fileset = document.createElement("fileset");
                copy.appendChild(fileset);
                fileset.setAttribute("dir", NLS.bind((String)"{0}/{1}/{2}/resources/", (Object[])new String[]{this.getBuildFolder(), configName, this.getFormatedName(required.getName())}));
            }
        }
        this.createWtkBuildTarget(build, configName);
    }

    private IPath[] resolveLibraryPaths(IMidletSuiteProject midletSuiteProject) throws AntennaExportException {
        IJavaProject javaProject = this.getMidletSuiteProject().getJavaProject();
        LibraryCollector collector = new LibraryCollector();
        try {
            collector.getRunner().run(javaProject, collector, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exc) {
            throw new AntennaExportException(exc, "Unable to resolve library dependecies.");
        }
        return collector.getLibraryPaths(false);
    }

    private void createWtkBuildTarget(Element parent, String configName) throws AntennaExportException {
        IPath[] libPaths;
        Document document = this.getDocument();
        StringBuffer buffer = new StringBuffer();
        IPath[] iPathArray = libPaths = this.resolveLibraryPaths(this.getMidletSuiteProject());
        int n = libPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            buffer.append(path.toOSString()).append(":");
            ++n2;
        }
        Object[] values = new String[]{this.getBuildFolder(), configName, this.getFormatedName(this.getMidletSuiteProject().getProject().getName())};
        Element wtkBuild = document.createElement("wtkbuild");
        wtkBuild.setAttribute("bootclasspath", buffer.toString());
        wtkBuild.setAttribute("destdir", NLS.bind((String)"{0}/{1}/{2}/bin/", (Object[])values));
        wtkBuild.setAttribute("preverify", "false");
        wtkBuild.setAttribute("encoding", "UTF-8");
        wtkBuild.setAttribute("source", "1.3");
        wtkBuild.setAttribute("sourcepath", "");
        wtkBuild.setAttribute("srcdir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])values));
        parent.appendChild(wtkBuild);
    }
}

