/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilder;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilderVisitor
implements IResourceVisitor,
IResourceDeltaVisitor {
    private IMidletSuiteProject suiteProject;
    private MTJBuildProperties properties;
    private List<IFile> resources = new ArrayList<IFile>();
    private List<IFile> classes = new ArrayList<IFile>();
    private de.schlichtherle.io.File jar;

    public PackageBuilderVisitor(IMidletSuiteProject suiteProject, de.schlichtherle.io.File jarFile) {
        this.properties = MTJBuildProperties.getBuildProperties(suiteProject);
        this.suiteProject = suiteProject;
        this.jar = jarFile;
    }

    public boolean visit(IResource resource) throws CoreException {
        IFile file;
        if (resource instanceof IFile && this.isOnBuildFolder(file = (IFile)resource)) {
            if (file.getName().endsWith(".class")) {
                IFile preverified = this.getPreVerifiedClassFile(file);
                if (preverified != null) {
                    if (this.isOnBuildProperties((IResource)file, true)) {
                        this.classes.add(preverified);
                    } else {
                        this.removeFromJAR(preverified);
                    }
                }
            } else if (this.isOnBuildProperties(resource, false)) {
                this.resources.add(file);
            } else {
                this.removeFromJAR(file);
            }
        }
        return true;
    }

    private boolean isOnBuildFolder(IFile file) throws JavaModelException {
        IFolder folder = PackageBuilder.getOutputFolder(this.suiteProject.getJavaProject());
        return folder.getLocation().isPrefixOf(file.getLocation());
    }

    private boolean isOnBuildProperties(IResource resource, boolean isClassFile) throws CoreException {
        IPath resourcePath;
        MTJRuntimeList runtimes = this.suiteProject.getRuntimeList();
        MTJRuntime active = runtimes.getActiveMTJRuntime();
        boolean result = false;
        if (active != null && !(resourcePath = this.getOutputFolderRelativePath(resource)).isEmpty() && !(resourcePath = this.findResourceOriginalPath(resourcePath, isClassFile)).isEmpty()) {
            result = this.isResourceFileOnBuildProperties(active, resourcePath);
        }
        return result;
    }

    private IPath findResourceOriginalPath(IPath resourcePath, boolean isClassFile) throws CoreException {
        Path result = Path.EMPTY;
        IResource[] sources = Utils.getSourceFolders(this.suiteProject.getJavaProject());
        if (isClassFile) {
            IPath sourcePath = this.getOutterClassName(resourcePath);
            IJavaProject jProject = this.suiteProject.getJavaProject();
            IJavaElement jElement = jProject.findElement(sourcePath);
            if (jElement != null) {
                String packageName = this.getPackageName(jElement);
                String sourceName = jElement.getElementName();
                resourcePath = new Path(packageName).append(sourceName);
            }
        }
        IResource[] iResourceArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IResource source = iResourceArray[n2];
            IContainer container = (IContainer)source.getAdapter(IContainer.class);
            if (container != null && (resource = container.findMember(resourcePath)) != null) {
                result = resource.getFullPath();
            }
            ++n2;
        }
        return result;
    }

    private boolean isResourceFileOnBuildProperties(MTJRuntime active, IPath resourcePath) throws CoreException {
        IResource[] includes;
        boolean result = false;
        IResource[] iResourceArray = includes = this.properties.getIncludes(active);
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            IResource include = iResourceArray[n2];
            IPath includePath = include.getFullPath();
            if (!includePath.equals((Object)resourcePath)) {
                if (includePath.isPrefixOf(resourcePath)) {
                    IResource[] excludes;
                    result = true;
                    IResource[] iResourceArray2 = excludes = this.properties.getExcludes(active);
                    int n3 = excludes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource exclude = iResourceArray2[n4];
                        IPath excludePath = exclude.getFullPath();
                        if (includePath.isPrefixOf(excludePath) && excludePath.isPrefixOf(resourcePath) || resourcePath.equals((Object)excludePath)) {
                            result = false;
                            break;
                        }
                        ++n4;
                    }
                }
            } else {
                result = true;
            }
            if (result) break;
            ++n2;
        }
        return result;
    }

    private IPath getOutterClassName(IPath classPath) {
        IPath result = classPath;
        String className = classPath.lastSegment();
        if (className != null && className.contains("$")) {
            className = className.substring(0, className.indexOf("$"));
            result = classPath.removeLastSegments(1).append(NLS.bind((String)"{0}.class", (Object)className));
        }
        return result;
    }

    private String getPackageName(IJavaElement element) {
        String result = "";
        IJavaElement parent = element.getParent();
        if (parent instanceof IPackageFragment) {
            IPackageFragment package_ = (IPackageFragment)parent;
            result = package_.getElementName().replace(".", "/");
        }
        return result;
    }

    private IPath getOutputFolderRelativePath(IResource resource) throws CoreException {
        IFolder folder = PackageBuilder.getOutputFolder(this.suiteProject.getJavaProject());
        if (folder.getFullPath().isPrefixOf(resource.getFullPath())) {
            IPath path = resource.getFullPath().removeFirstSegments(folder.getFullPath().segmentCount());
            return new Path(path.toString());
        }
        return new Path("");
    }

    private IFile getPreVerifiedClassFile(IFile clazz) throws CoreException {
        IFolder folder = this.suiteProject.getVerifiedClassesOutputFolder((IProgressMonitor)new NullProgressMonitor());
        IFile preverfied = folder.getFile(this.getOutputFolderRelativePath((IResource)clazz));
        if (preverfied.exists()) {
            return preverfied;
        }
        return null;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    this.visit((IResource)file);
                    break;
                }
                case 2: {
                    this.removeFromJAR(file);
                }
            }
        }
        return true;
    }

    private void removeFromJAR(IFile file) throws CoreException {
        de.schlichtherle.io.File zipFile;
        IPath zipPath = null;
        zipPath = file.getName().endsWith(".class") ? PackageBuilder.getClassZipPath(this.suiteProject, file) : PackageBuilder.getResourceZipPath(this.suiteProject, file);
        if (zipPath != null && (zipFile = new de.schlichtherle.io.File((File)this.jar, zipPath.toString())).exists()) {
            zipFile.delete();
        }
    }

    public List<IFile> getResourcesToPackage() {
        ArrayList<IFile> copy = new ArrayList<IFile>();
        copy.addAll(this.resources);
        return copy;
    }

    public List<IFile> getClassesToPackage() {
        ArrayList<IFile> copy = new ArrayList<IFile>();
        copy.addAll(this.classes);
        return copy;
    }
}

