/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preprocessor;

import antenna.preprocessor.v3.ILineFilter;
import antenna.preprocessor.v3.ILogger;
import antenna.preprocessor.v3.IPreprocessorListener;
import antenna.preprocessor.v3.PPException;
import antenna.preprocessor.v3.Preprocessor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.build.preprocessor.PreprocessorHelper;
import org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapperAccess;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class PreprocessorBuilder
extends MTJIncrementalProjectBuilder {
    private BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    public static final String PROBLEM_MARKER = "org.eclipse.mtj.core.preprocessor.problemmarker";
    public static final String PROCESSED_DIRECTORY = ".processed";
    private static final String PROCESSED_PATH = "/.processed";
    private BuildLoggingConfiguration buildLoggingConfig = BuildLoggingConfiguration.getInstance();
    private boolean checkedForHook = false;

    public static IFile getOutputFile(IResource resource) {
        IPath projectRelativePath = new Path(PROCESSED_PATH).append(resource.getProjectRelativePath());
        return resource.getProject().getFile(projectRelativePath);
    }

    public static IProject getOutputProject(IProject project) {
        String ppProjectName = "." + project.getName() + "_PP";
        return MTJCore.getWorkspace().getRoot().getProject(ppProjectName);
    }

    public static boolean isPreprocessed(IResource resource) {
        IPath projectPath = resource.getProjectRelativePath();
        return projectPath.segment(0).equals(PROCESSED_DIRECTORY);
    }

    private void addDebuglevelDefines(Preprocessor preprocessor) throws PPException {
        String debuglevel = PreferenceAccessor.instance.getPreprecessorDebuglevel(this.getProject());
        if (PreprocessorHelper.isLegalDebuglevel(debuglevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append("DEBUG").append("=").append(debuglevel);
            preprocessor.addDefines(sb.toString());
        }
    }

    protected IProject[] doBuild(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("> PreprocessorBuilder.build");
        }
        if (!this.checkedForHook) {
            if (!SourceMapperAccess.isHookCodeInstalled()) {
                MTJLogger.log(2, "Preprocessor invoked, but hook is not installed.  Consult the installation instructions for MTJ.");
            }
            this.checkedForHook = true;
        }
        this.doPreprocessing(kind, monitor);
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("< PreprocessorBuilder.build");
        }
        return null;
    }

    protected void doClean(int kind, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)Messages.PreprocessorBuilder_cleaningProcessedFolder, (Object)PROCESSED_PATH));
        IProject srcProject = this.getProject();
        IFolder folder = srcProject.getFolder(PROCESSED_PATH);
        Utils.clearContainer((IContainer)folder, monitor);
    }

    protected String getBuilderId() {
        return "org.eclipse.mtj.core.preprocessor";
    }

    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_PREPROCESS;
    }

    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_PREPROCESS;
    }

    private void clearPreprocessorMarkers(IResource resource) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = resource.findMarkers(PROBLEM_MARKER, true, 1);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker element = iMarkerArray[n2];
            element.delete();
            ++n2;
        }
    }

    private void createParentFolders(IResource resource, IProgressMonitor monitor) throws CoreException {
        IContainer parent;
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("> PreprocessorBuilder.createParentFolders; resource = " + resource);
        }
        if ((parent = resource.getParent()).getType() == 2) {
            this.createParentFolders((IResource)parent, monitor);
            IFolder folder = (IFolder)parent;
            if (!folder.exists()) {
                folder.create(true, true, monitor);
                folder.setDerived(true);
            }
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("< PreprocessorBuilder.createParentFolders");
        }
    }

    protected void createResourceMarker(IResource resource, IDocument document, String message, int lineNumber, int offset, int length, boolean error) {
        int severity = error ? 2 : 1;
        try {
            IMarker marker = resource.createMarker(PROBLEM_MARKER);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            int start = document.getLineOffset(lineNumber) + offset;
            int end = start + length;
            marker.setAttribute("charStart", start);
            marker.setAttribute("charEnd", end);
        }
        catch (Exception e) {
            MTJLogger.log(4, e);
        }
    }

    private void doPreprocessing(int kind, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.PreprocessorBuilder_preprocessingSourceFiles);
        IProject project = this.getProject();
        ResourceVisitor visitor = null;
        monitor.subTask(Messages.PreprocessorBuilder_collectingSources);
        IResourceDelta delta = this.getDelta(project);
        if (delta != null) {
            visitor = new ResourceDeltaVisitor(monitor);
            delta.accept((IResourceDeltaVisitor)visitor);
        } else {
            visitor = new ResourceVisitor(monitor);
            project.accept((IResourceVisitor)visitor);
        }
        monitor.worked(1);
        this.assertCancelation(monitor, true);
        monitor.subTask(Messages.PreprocessorBuilder_preprocessingSources);
        List<IFile> sources = visitor.getSources();
        for (IFile source : sources) {
            this.preprocess((IResource)source, monitor);
            monitor.worked(1);
            this.assertCancelation(monitor, true);
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("< PreprocessorBuilder.doPreprocessing");
        }
        monitor.done();
    }

    private String getActiveSymbolSetString() {
        IMTJProject midletSuite = this.getMTJProject();
        ISymbolSet symbolSet = midletSuite.getRuntimeList().getActiveMTJRuntime().getSymbolSetForPreprocessing();
        return symbolSet.getSymbolSetString();
    }

    private String getContentEncoding(IFile file) throws CoreException {
        String encoding = file.getCharset();
        if (encoding == null) {
            encoding = System.getProperty("file.encoding", "UTF-8");
        }
        return encoding;
    }

    private IDocument getDocumentForFile(IFile file) throws CoreException {
        StringWriter stringWriter;
        block14: {
            String charset = file.getCharset(true);
            InputStream contentStream = file.getContents();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(contentStream, charset));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            String line = null;
            stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        writer.println(line);
                    }
                }
                catch (IOException e) {
                    MTJStatusHandler.throwCoreException(4, -999, e);
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return new Document(stringWriter.toString());
    }

    private boolean isOnBuildPath(IResource resource, IProgressMonitor monitor) {
        IJavaElement javaElement;
        boolean onBuildPath = false;
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("> PreprocessorBuilder.isOnBuildPath; resource = " + resource);
        }
        if ((javaElement = JavaCore.create((IFile)((IFile)resource))) != null) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement.getAncestor(3);
            onBuildPath = root.exists();
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("< PreprocessorBuilder.isOnBuildPath; returning = " + onBuildPath);
        }
        return onBuildPath;
    }

    protected void preprocess(final IResource resource, IProgressMonitor monitor) throws CoreException {
        block14: {
            if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                this.consoleProxy.traceln("> PreprocessorBuilder.preprocess; resource = " + resource);
            }
            final IDocument document = this.getDocumentForFile((IFile)resource);
            this.clearPreprocessorMarkers(resource);
            ILogger logger = new ILogger(){

                public void log(String message) {
                    if (PreprocessorBuilder.this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                        PreprocessorBuilder.this.consoleProxy.traceln(message);
                    }
                }
            };
            ILineFilter filter = new ILineFilter(){

                public String filter(String line) {
                    return line;
                }
            };
            IPreprocessorListener listener = new IPreprocessorListener(){

                public void error(Exception e, int lineNumber, int offset, int length) {
                    if (PreprocessorBuilder.this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                        PreprocessorBuilder.this.consoleProxy.getConsoleWriter(IBuildConsoleProxy.Stream.ERROR).println("Preprocessor error: " + e);
                    }
                    PreprocessorBuilder.this.createResourceMarker(resource, document, e.getMessage(), lineNumber, offset, length, true);
                }

                public void warning(String message, int lineNumber, int offset, int length) {
                    if (PreprocessorBuilder.this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                        PreprocessorBuilder.this.consoleProxy.getConsoleWriter(IBuildConsoleProxy.Stream.OUTPUT).println("Preprocessor warning: " + message);
                    }
                    PreprocessorBuilder.this.createResourceMarker(resource, document, message, lineNumber, offset, length, false);
                }
            };
            IFile file = (IFile)resource;
            File localFile = file.getLocation().toFile();
            String charset = this.getContentEncoding(file);
            InputStream is = file.getContents();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Preprocessor preprocessor = new Preprocessor(logger, filter);
            preprocessor.setFile(localFile);
            preprocessor.setListener(listener);
            try {
                try {
                    List<ISymbolSet> sets = this.getMTJProject().getRuntimeList().getActiveMTJRuntime().getWorkspaceScopeSymbolSets();
                    for (ISymbolSet symbols : sets) {
                        preprocessor.addDefines(symbols.toString());
                    }
                    preprocessor.addDefines(this.getActiveSymbolSetString());
                    this.addDebuglevelDefines(preprocessor);
                    preprocessor.preprocess(is, (OutputStream)bos, charset);
                    this.writeProcessedResults(resource, bos.toByteArray(), charset, monitor);
                }
                catch (Exception e1) {
                    MTJStatusHandler.throwCoreException(4, -999, e1);
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("< PreprocessorBuilder.preprocess");
        }
    }

    private void setReadOnly(IFile outputFile, boolean readOnly) throws CoreException {
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(readOnly);
        outputFile.setResourceAttributes(attributes);
    }

    private boolean shouldBeProcessed(IResource resource, IProgressMonitor monitor) throws CoreException {
        return resource.getName().endsWith(".java") && !PreprocessorBuilder.isPreprocessed(resource) && this.isOnBuildPath(resource, monitor);
    }

    private void writeProcessedResults(IResource resource, byte[] contents, String charset, IProgressMonitor monitor) throws CoreException {
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("> PreprocessorBuilder.writeProcessedResults");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(contents);
        IFile outputFile = PreprocessorBuilder.getOutputFile(resource);
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("- PreprocessorBuilder.writeProcessedResults; outputFile = " + outputFile);
        }
        if (outputFile.exists()) {
            if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                this.consoleProxy.traceln("- PreprocessorBuilder.writeProcessedResults; outputFile exists, setting new contents");
            }
            this.setReadOnly(outputFile, false);
            outputFile.setContents((InputStream)is, true, false, monitor);
        } else {
            IContainer container = outputFile.getParent();
            if (!container.exists()) {
                this.createParentFolders((IResource)outputFile, monitor);
            }
            outputFile.create((InputStream)is, false, monitor);
        }
        outputFile.setCharset(charset, monitor);
        outputFile.setDerived(true);
        this.setReadOnly(outputFile, true);
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            this.consoleProxy.traceln("< PreprocessorBuilder.writeProcessedResults");
        }
    }

    private class ResourceDeltaVisitor
    extends ResourceVisitor
    implements IResourceDeltaVisitor {
        protected ResourceDeltaVisitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean value = false;
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    value = this.visit(delta.getResource());
                    break;
                }
                case 2: {
                    IFile outputFile = PreprocessorBuilder.getOutputFile(delta.getResource());
                    if (!outputFile.exists()) break;
                    outputFile.delete(true, this.monitor);
                }
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResourceVisitor
    implements IResourceVisitor {
        protected IProgressMonitor monitor;
        protected List<IFile> sources = new ArrayList<IFile>();

        protected ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && PreprocessorBuilder.this.shouldBeProcessed(resource, this.monitor)) {
                IFile source = (IFile)resource;
                this.sources.add(source);
            }
            return true;
        }

        public List<IFile> getSources() {
            ArrayList<IFile> copy = new ArrayList<IFile>();
            copy.addAll(this.sources);
            return copy;
        }
    }
}

