/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.IPreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationUtils;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuildInfo;
import org.eclipse.mtj.internal.core.util.AbstractClasspathEntryVisitor;
import org.eclipse.mtj.internal.core.util.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.internal.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceDeltaBuilder {
    private BuildInfo buildInfo;
    private BuildLoggingConfiguration buildLoggingConfig;
    private BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    private IWorkspaceRoot workspaceRoot;

    public ResourceDeltaBuilder(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        this.buildLoggingConfig = BuildLoggingConfiguration.getInstance();
        this.workspaceRoot = MTJCore.getWorkspace().getRoot();
    }

    private void attemptLibraryPreverification(IResource srcResource, de.schlichtherle.io.File srcFile, IFolder verifiedLibsFolder, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        this.buildInfo.setPackageDirty(true);
        try {
            IPreverificationError[] errors = this.buildInfo.getMidletSuite().preverifyJarFile((File)srcFile, verifiedLibsFolder, monitor);
            if (errors.length > 0) {
                this.createJarErrorMarker(srcResource, srcFile, errors);
            }
        }
        finally {
            verifiedLibsFolder.refreshLocal(2, monitor);
        }
    }

    private void createErrorMarkerFor(IPreverificationError error) throws JavaModelException, CoreException {
        IResource resource;
        IMarker marker = null;
        IClassErrorInformation classInfo = ((IPreverificationErrorLocation)error.getLocation()).getClassInformation();
        String typeName = classInfo == null ? "" : classInfo.getName().replace('/', '.');
        String message = PreverificationUtils.getErrorText(error);
        IType type = this.buildInfo.getCurrentJavaProject().findType(typeName);
        if (type != null && (resource = type.getResource()) != null) {
            marker = resource.createMarker("org.eclipse.jdt.core.problem");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 2);
            int lineNumber = ((IPreverificationErrorLocation)error.getLocation()).getLineNumber();
            if (lineNumber != -1) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            this.setMarkerRangeAttributes(marker, error, type);
        }
        if (marker == null) {
            this.createProjectLevelPreverifyMarker(typeName, message);
        }
    }

    private IPath[] getOutputLocations(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        OutputLocationsCollectionVisitor visitor = new OutputLocationsCollectionVisitor();
        visitor.getRunner().run(javaProject, visitor, monitor);
        Set<IPath> outputLocations = visitor.getOutputLocations();
        return outputLocations.toArray(new IPath[outputLocations.size()]);
    }

    private void createJarErrorMarker(IResource srcResource, de.schlichtherle.io.File srcFile, IPreverificationError[] errors) throws CoreException {
        StringBuffer sb = new StringBuffer("Preverification errors:\n");
        IPreverificationError[] iPreverificationErrorArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            IPreverificationError error = iPreverificationErrorArray[n2];
            sb.append(PreverificationUtils.getErrorText(error)).append("\n");
            ++n2;
        }
        IMarker marker = srcResource.createMarker("org.eclipse.jdt.core.problem");
        marker.setAttribute("message", (Object)sb.toString());
        marker.setAttribute("severity", 2);
    }

    private void createProjectLevelPreverifyMarker(String typeName, String message) throws CoreException {
        StringBuffer sb = new StringBuffer("Type ");
        sb.append(typeName).append(" ").append(message);
        IProject project = this.buildInfo.getCurrentJavaProject().getProject();
        IMarker marker = project.createMarker("org.eclipse.jdt.core.problem");
        marker.setAttribute("message", (Object)sb.toString());
        marker.setAttribute("severity", 2);
    }

    private boolean doClassesRequirePreverification(de.schlichtherle.io.File srcFile, de.schlichtherle.io.File tgtFile) {
        boolean requirePreverify = false;
        if (srcFile.isDirectory()) {
            if (!tgtFile.exists()) {
                requirePreverify = true;
            } else {
                File[] classesAndDirectories;
                File[] fileArray = classesAndDirectories = srcFile.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory() || pathname.getName().endsWith(".class");
                    }
                });
                int n = classesAndDirectories.length;
                int n2 = 0;
                while (n2 < n) {
                    File classesAndDirectorie = fileArray[n2];
                    de.schlichtherle.io.File srcFile2 = new de.schlichtherle.io.File(classesAndDirectorie);
                    de.schlichtherle.io.File tgtFile2 = new de.schlichtherle.io.File((File)tgtFile, classesAndDirectorie.getName());
                    requirePreverify = this.doClassesRequirePreverification(srcFile2, tgtFile2);
                    if (!requirePreverify) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            requirePreverify = this.isSourceNewerThanTarget(srcFile, tgtFile);
        }
        return requirePreverify;
    }

    private void preverifyClasses(List<IFile> classes, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.handleClassAddsAndChanges; classFiles count = " + classes.size());
        }
        this.buildInfo.setPackageDirty(true);
        IResource[] resources = classes.toArray(new IResource[classes.size()]);
        IFolder outputFolder = this.buildInfo.getVerifiedClassesFolder(monitor);
        try {
            IPreverificationError[] errors = this.buildInfo.getMidletSuite().preverify(resources, outputFolder, monitor);
            outputFolder.refreshLocal(2, monitor);
            IPreverificationError[] iPreverificationErrorArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                IPreverificationError error = iPreverificationErrorArray[n2];
                this.createErrorMarkerFor(error);
                ++n2;
            }
        }
        finally {
            outputFolder.refreshLocal(2, monitor);
        }
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.handleClassAddsAndChanges");
        }
    }

    private boolean isSourceNewerThanTarget(de.schlichtherle.io.File srcFile, de.schlichtherle.io.File tgtFile) {
        return !tgtFile.exists() || tgtFile.lastModified() < srcFile.lastModified();
    }

    private void setMarkerRangeAttributes(IMarker marker, IPreverificationError error, IType type) throws CoreException {
        int start = 1;
        int end = 1;
        switch (((IPreverificationErrorLocation)error.getLocation()).getLocationType().getTypeCode()) {
            case 0: {
                ISourceRange sourceRange = type.getNameRange();
                start = sourceRange.getOffset();
                end = start + sourceRange.getLength();
            }
        }
        marker.setAttribute("charStart", start);
        marker.setAttribute("charEnd", end);
    }

    void build(IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("> ResourceDeltaBuilder.build");
        }
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(monitor);
        IResourceDelta resourceDelta = this.buildInfo.getCurrentResourceDelta();
        if (resourceDelta == null) {
            IPath[] outputs;
            IPath[] iPathArray = outputs = this.getOutputLocations(this.buildInfo.getCurrentJavaProject(), monitor);
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                IPath output = iPathArray[n2];
                IResource resource = this.workspaceRoot.findMember(output.makeAbsolute());
                if (resource != null) {
                    resource.accept((IResourceVisitor)visitor);
                }
                ++n2;
            }
        } else {
            resourceDelta.accept((IResourceDeltaVisitor)visitor);
        }
        this.preverifyClasses(visitor.getClasses(), monitor);
        if (this.buildLoggingConfig.isPreverifierTraceEnabled()) {
            this.consoleProxy.traceln("< ResourceDeltaBuilder.build");
        }
    }

    void preverifyLibraries(IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        IFolder verifiedClassesFolder = this.buildInfo.getVerifiedClassesFolder(monitor);
        IFolder verifiedLibsFolder = this.buildInfo.getVerifiedLibsFolder(monitor);
        LibraryCollectionVisitor visitor = new LibraryCollectionVisitor();
        visitor.getRunner().run(this.buildInfo.getCurrentJavaProject(), visitor, monitor);
        ArrayList<IClasspathEntry> resolvedEntries = visitor.getLibraryEntries();
        for (IClasspathEntry entry : resolvedEntries) {
            Object resolvedEntry = Utils.getResolvedClasspathEntry(entry);
            IResource srcResource = resolvedEntry instanceof IResource ? (IResource)resolvedEntry : this.buildInfo.getCurrentJavaProject().getProject();
            IPath srcPath = entry.getPath().makeAbsolute();
            de.schlichtherle.io.File srcFile = new de.schlichtherle.io.File(Utils.getResolvedClasspathEntryFile(entry));
            if (srcFile == null || this.buildInfo.hasLibraryBeenPreverified(srcFile)) continue;
            this.buildInfo.addPreverifiedLibrary(srcFile);
            IFolder target = null;
            IFolder targetFolder = null;
            if (srcFile.isDirectory() && !srcFile.isArchive()) {
                target = verifiedClassesFolder;
                targetFolder = verifiedClassesFolder;
            } else {
                target = verifiedLibsFolder.getFile(srcPath.lastSegment());
                targetFolder = verifiedLibsFolder;
            }
            de.schlichtherle.io.File tgtFile = new de.schlichtherle.io.File(target.getLocation().toFile());
            boolean requiresPreverification = false;
            requiresPreverification = srcFile.isDirectory() ? this.doClassesRequirePreverification(srcFile, tgtFile) : this.isSourceNewerThanTarget(srcFile, tgtFile);
            if (!requiresPreverification) continue;
            this.attemptLibraryPreverification(srcResource, srcFile, targetFolder, monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryCollectionVisitor
    extends FilteringClasspathEntryVisitor {
        private ArrayList<IClasspathEntry> libraryEntries = new ArrayList();

        private LibraryCollectionVisitor() {
        }

        public ArrayList<IClasspathEntry> getLibraryEntries() {
            return this.libraryEntries;
        }

        @Override
        public void visitLibraryEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
            if (this.isLibraryExported(entry)) {
                this.libraryEntries.add(entry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputLocationsCollectionVisitor
    extends AbstractClasspathEntryVisitor {
        private Set<IPath> outputLocations = new HashSet<IPath>();

        private OutputLocationsCollectionVisitor() {
        }

        public Set<IPath> getOutputLocations() {
            return this.outputLocations;
        }

        @Override
        public void visitSourceEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
            IPath outputLocation = entry.getOutputLocation();
            if (outputLocation == null) {
                outputLocation = javaProject.getOutputLocation();
            }
            this.outputLocations.add(outputLocation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceDeltaVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private List<IFile> classes;
        private IProgressMonitor monitor;

        public ResourceDeltaVisitor(IProgressMonitor monitor) throws CoreException {
            this.monitor = monitor;
            this.classes = new ArrayList<IFile>();
        }

        public List<IFile> getClasses() {
            ArrayList<IFile> copy = new ArrayList<IFile>();
            copy.addAll(this.classes);
            return copy;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (this.isClassFile(resource)) {
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        this.visit(delta.getResource());
                        break;
                    }
                    case 2: {
                        this.removeVerifiedResource(ResourceDeltaBuilder.this.buildInfo, resource, this.monitor);
                    }
                }
            }
            return true;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.isClassFile(resource)) {
                IFile file = (IFile)resource;
                this.classes.add(file);
            }
            return true;
        }

        private void removeVerifiedResource(BuildInfo buildInfo, IResource resource, IProgressMonitor monitor) throws CoreException {
            IFolder verifiedFolder;
            IResource verifiedClass;
            IJavaProject javaProject = buildInfo.getCurrentJavaProject();
            IPath path = Utils.extractsSourceFolderRelativePath(javaProject, resource);
            if (path != null && (verifiedClass = (verifiedFolder = buildInfo.getVerifiedClassesFolder(monitor)).findMember(path)) != null) {
                verifiedClass.delete(true, monitor);
            }
        }

        private boolean isClassFile(IResource resource) {
            return resource.getType() == 1 && resource.getName().endsWith(".class") && ResourceDeltaBuilder.this.buildInfo.isOutputResource(resource);
        }
    }
}

