/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.sign;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.MTJCoreErrors;
import org.eclipse.mtj.internal.core.Messages;

public class KeyChainSet {
    private X509Certificate[] m_certChain;
    private PrivateKey m_key;
    private String m_strProvider;

    public static KeyChainSet getInstance(InputStream keyStoreStream, String strKeyStorePass, String strKeyAlias, String strKeyPass) throws CoreException {
        return KeyChainSet.getInstance(keyStoreStream, null, null, strKeyStorePass, strKeyAlias, strKeyPass);
    }

    public static KeyChainSet getInstance(InputStream keyStoreStream, String strKeyStoreType, String strKeyStoreProvider, String strKeyStorePass, String strKeyAlias, String strKeyPass) throws CoreException {
        KeyStore store = null;
        PrivateKey theKey = null;
        X509Certificate[] orderedCertChain = null;
        if (strKeyAlias == null) {
            MTJCoreErrors.throwCoreExceptionError(999, Messages.KeyChainSet_noAliasSelected);
        }
        if (strKeyStoreProvider != null && strKeyStoreProvider.length() == 0) {
            strKeyStoreProvider = null;
        }
        if (strKeyStoreType != null && strKeyStoreType.length() == 0) {
            strKeyStoreType = null;
        }
        try {
            if (strKeyStoreType == null) {
                strKeyStoreType = KeyStore.getDefaultType();
            }
            store = strKeyStoreProvider == null ? KeyStore.getInstance(strKeyStoreType) : KeyStore.getInstance(strKeyStoreType, strKeyStoreProvider);
            store.load(keyStoreStream, strKeyStorePass.toCharArray());
            Key k = store.getKey(strKeyAlias, strKeyPass.toCharArray());
            if (k == null) {
                MTJCoreErrors.throwCoreExceptionError(10006, Messages.MTJCoreError_10006);
            }
            if (!(k instanceof PrivateKey)) {
                MTJCoreErrors.throwCoreExceptionError(10008, Messages.MTJCoreError_10008);
            }
            theKey = (PrivateKey)k;
            Certificate[] rawChain = store.getCertificateChain(strKeyAlias);
            Certificate rawCert = store.getCertificate(strKeyAlias);
            if (rawChain != null && rawCert != null) {
                if (!(rawCert instanceof X509Certificate)) {
                    MTJCoreErrors.throwCoreExceptionError(10009, Messages.MTJCoreError_10009);
                }
                X509Certificate baseCert = (X509Certificate)rawCert;
                X509Certificate[] certChain = new X509Certificate[rawChain.length];
                int i = 0;
                while (i < rawChain.length) {
                    if (rawChain[i] instanceof X509Certificate) {
                        certChain[i] = (X509Certificate)rawChain[i];
                    } else {
                        MTJCoreErrors.throwCoreExceptionError(10009, Messages.MTJCoreError_10009);
                    }
                    ++i;
                }
                if (certChain[0].equals(baseCert)) {
                    orderedCertChain = certChain;
                } else {
                    orderedCertChain = new X509Certificate[rawChain.length];
                    orderedCertChain[0] = baseCert;
                    i = 1;
                    while (i < rawChain.length) {
                        orderedCertChain[i] = KeyChainSet.findParentCertificate(orderedCertChain[i - 1], certChain);
                        if (orderedCertChain[i] == null) {
                            MTJCoreErrors.throwCoreExceptionError(10009, Messages.MTJCoreError_10009);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IOException iOException) {
            MTJCoreErrors.throwCoreExceptionError(10001, Messages.MTJCoreError_10001);
        }
        catch (KeyStoreException kse) {
            MTJCoreErrors.throwCoreExceptionError(10002, Messages.MTJCoreError_10002, kse);
        }
        catch (NoSuchProviderException nspe) {
            MTJCoreErrors.throwCoreExceptionError(10003, Messages.MTJCoreError_10003, nspe);
        }
        catch (NoSuchAlgorithmException nsae) {
            MTJCoreErrors.throwCoreExceptionError(10004, Messages.MTJCoreError_10004, nsae);
        }
        catch (CertificateException ce) {
            MTJCoreErrors.throwCoreExceptionError(10005, Messages.MTJCoreError_10005, ce);
        }
        catch (UnrecoverableKeyException uke) {
            MTJCoreErrors.throwCoreExceptionError(10007, Messages.MTJCoreError_10007, uke);
        }
        KeyChainSet kcs = new KeyChainSet(theKey, orderedCertChain, strKeyStoreProvider);
        return kcs;
    }

    private static X509Certificate findParentCertificate(X509Certificate child, X509Certificate[] chain) {
        Principal issuer = child.getIssuerDN();
        X509Certificate retval = null;
        int i = 0;
        while (i < chain.length) {
            Principal certDN;
            if (chain[i] != null && (certDN = chain[i].getSubjectDN()).equals(issuer)) {
                retval = chain[i];
                chain[i] = null;
                break;
            }
            ++i;
        }
        return retval;
    }

    private KeyChainSet(PrivateKey key, X509Certificate[] certChain, String strProvider) {
        this.m_key = key;
        this.m_certChain = certChain;
        this.m_strProvider = strProvider;
    }

    public X509Certificate[] getCertificateChain() {
        return this.m_certChain;
    }

    public PrivateKey getKey() {
        return this.m_key;
    }

    public String getProvider() {
        return this.m_strProvider;
    }

    void setCertificateChain(X509Certificate[] value) {
        this.m_certChain = value;
    }

    void setKey(PrivateKey value) {
        this.m_key = value;
    }

    void setProvider(String value) {
        this.m_strProvider = value;
    }
}

