/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.classpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.internal.core.externallibrary.classpath.ExternalLibraryClasspathContainer;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class ExternalLibraryClasspathContainerInitializer
extends ClasspathContainerInitializer {
    String description = null;

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return false;
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null) {
            return null;
        }
        return containerPath.toString();
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        if (this.description != null) {
            return this.description;
        }
        return super.getDescription(containerPath, project);
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (this.isMidletLibraryContainer(containerPath)) {
            String midletLibName = containerPath.segment(1);
            IExternalLibrary midletLibrary = ExternalLibraryManager.getInstance().getMidletLibrary(midletLibName);
            if (midletLibrary != null) {
                ExternalLibraryClasspathContainer container = new ExternalLibraryClasspathContainer(midletLibrary);
                this.description = String.valueOf(midletLibName) + " [" + midletLibrary.getVersion().toString() + "]";
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            } else {
                MTJLogger.log(4, "Could not load " + containerPath.toString(), null);
            }
        }
    }

    private boolean isMidletLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.mtj.core.EXTERNAL_LIBRARY".equals(path.segment(0));
    }
}

