/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.model.security;

public class ProtectionDomain {
    private ProtectionDomainType protectionDomain = ProtectionDomainType.UNTRUSTED;

    public ProtectionDomain(ProtectionDomainType protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public ProtectionDomain(String protectionDomainType) throws IllegalArgumentException {
        if (protectionDomainType == null) {
            throw new IllegalArgumentException("Domain string must not be null");
        }
        this.protectionDomain = ProtectionDomainType.getProtectionDomainType(protectionDomainType);
    }

    public ProtectionDomainType getProtectionDomainType() {
        return this.protectionDomain;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.protectionDomain == null ? 0 : this.protectionDomain.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectionDomain)) {
            return false;
        }
        ProtectionDomain other = (ProtectionDomain)obj;
        return !(this.protectionDomain == null ? other.protectionDomain != null : !this.protectionDomain.equals((Object)other.protectionDomain));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProtectionDomainType {
        MANUFACTURER,
        OPERATOR,
        THIRD_PARTY,
        UNTRUSTED;

        private static final String MANUFACTURER_KEY = "MANUFACTURER";
        private static final String OPERATOR_KEY = "OPERATOR";
        private static final String THIRD_PARTY_KEY = "THIRD_PARTY";
        private static final String UNTRUSTED_KEY = "UNTRUSTED";

        public static ProtectionDomainType getProtectionDomainType(String protectionDomain) throws IllegalArgumentException {
            if (protectionDomain.equals(MANUFACTURER_KEY)) {
                return MANUFACTURER;
            }
            if (protectionDomain.equals(OPERATOR_KEY)) {
                return OPERATOR;
            }
            if (protectionDomain.equals(THIRD_PARTY_KEY)) {
                return THIRD_PARTY;
            }
            if (protectionDomain.equals(UNTRUSTED_KEY)) {
                return UNTRUSTED;
            }
            throw new IllegalArgumentException("Protection  Domain string must be one of the following: MANUFACTURER | OPERATOR | THIRD_PARTY | UNTRUSTED");
        }
    }
}

