/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.l10n;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.l10n.Messages;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

public class L10nApi {
    public static final String LOCALIZATION_DATA_FILE = "Localization Data";
    public static final String DESTINATION = "destination";
    public static final String PACKAGE = "package";
    private static final String DEFAULT_LOCALE = "defaultlocale";
    public static final String L10N_RESOURCES_CLASS = "L10nResources.java";
    public static final String L10N_CONSTANTS_CLASS = "L10nConstants.java";

    public static boolean createLocalizationApi(IProject project, IPackageFragment _package, IPath _properties) throws CoreException {
        return L10nApi.updateLocalizationApi(project, _package, _properties, null);
    }

    public static String buildL10nConstantsClass(IProject project, IPackageFragment _package) throws CoreException {
        InputStream stream = MTJCore.getResourceAsStream((IPath)new Path("templates/L10nConstants.java.template"));
        if (stream == null) {
            MTJStatusHandler.throwCoreException(4, -999, "Unable to load templates/L10nResources.java.template.");
        }
        StringBuffer localesBuffer = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>();
        L10nModel model = L10nApi.loadL10nModel(project);
        if (!model.isValid()) {
            MTJStatusHandler.throwCoreException(4, -999, Messages.L10nBuilder_InvalidModel);
        }
        List<IDocumentElementNode> localeNodes = model.getLocales().getChildren();
        for (IDocumentElementNode localeElement : localeNodes) {
            if (!(localeElement instanceof L10nLocale)) continue;
            L10nLocale locale = (L10nLocale)localeElement;
            localesBuffer.append(L10nApi.writeStringConstantDeclaration(locale.getName().toUpperCase(), locale.getName()));
            IDocumentElementNode[] entryNodes = locale.getChildNodes();
            int i = 0;
            while (i < entryNodes.length) {
                L10nEntry entry;
                if (entryNodes[i] instanceof L10nEntry && !keys.contains((entry = (L10nEntry)entryNodes[i]).getKey().toUpperCase())) {
                    keys.add(entry.getKey().toUpperCase());
                }
                ++i;
            }
        }
        StringBuffer constntBuffer = new StringBuffer();
        for (String key : keys) {
            constntBuffer.append(L10nApi.writeStringConstantDeclaration(key, key));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String packName = _package.getElementName();
        if (packName != null && packName.length() > 0) {
            map.put(PACKAGE, NLS.bind((String)"package {0};", (Object)packName));
        } else {
            map.put(PACKAGE, "");
        }
        map.put("locales", localesBuffer.toString());
        map.put("keys", constntBuffer.toString());
        StringBuffer buffer = new StringBuffer(Utils.getStreamContent(stream));
        String code = ReplaceableParametersProcessor.processReplaceableValues(buffer.toString(), map);
        return code;
    }

    public static String buildL10nResourcesClass(IPackageFragment _package, IPath _properties, String _defaultLocale) throws CoreException {
        InputStream stream = MTJCore.getResourceAsStream((IPath)new Path("templates/L10nResources.java.template"));
        if (stream == null) {
            MTJStatusHandler.throwCoreException(4, -999, "Unable to load templates/L10nResources.java.template.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DESTINATION, _properties.removeFirstSegments(1).toString());
        String packName = _package.getElementName();
        if (packName != null && packName.length() > 0) {
            map.put(PACKAGE, NLS.bind((String)"package {0};", (Object)packName));
        } else {
            map.put(PACKAGE, "");
        }
        if (_defaultLocale != null) {
            map.put(DEFAULT_LOCALE, _defaultLocale);
        }
        StringBuffer buffer = new StringBuffer(Utils.getStreamContent(stream));
        String code = ReplaceableParametersProcessor.processReplaceableValues(buffer.toString(), map);
        return code;
    }

    public static L10nModel loadL10nModel(IProject project) throws CoreException {
        L10nModel model = null;
        IFile l10nData = project.getFile(LOCALIZATION_DATA_FILE);
        if (l10nData.exists()) {
            IPath l10nDataPath = l10nData.getLocation();
            if (l10nDataPath == null) {
                throw new CoreException(MTJStatusHandler.newStatus(4, -999, Messages.L10nBuilder_loadL10nModel_CanNotRealizeLocation));
            }
        } else {
            throw new CoreException(MTJStatusHandler.newStatus(4, -999, Messages.L10nBuilder_LocalizationDataDoesNotExist));
        }
        model = new L10nModel((IDocument)Utils.getTextDocument(l10nData.getContents()), false);
        model.setUnderlyingResource((IResource)l10nData);
        model.load();
        return model;
    }

    public static boolean createLocalizationFile(IProject _project, IPath _properties, IJavaElement _package) throws JavaModelException, IOException {
        L10nModel model = new L10nModel((IDocument)new Document(), false);
        L10nLocales locales = model.getLocales();
        locales.setDestination(_properties.toString());
        locales.setPackage(_package.getElementName());
        IPath path = _project.getLocation().append(LOCALIZATION_DATA_FILE);
        IFile file = _project.getWorkspace().getRoot().getFileForLocation(path);
        if (file == null) {
            throw new IOException(Messages.L10nApi_unableToCreateL10nFile);
        }
        model.setUnderlyingResource((IResource)file);
        model.save();
        return file.exists();
    }

    private static String writeStringConstantDeclaration(String name, String value) {
        return NLS.bind((String)"\t\tpublic static final String {0} = \"{1}\";\n", (Object[])new String[]{name.replace("-", "_"), value});
    }

    public static void syncronizeApi(L10nModel model) throws CoreException {
        IPackageFragment[] packages;
        IResource resource = model.getUnderlyingResource();
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        IPackageFragment[] iPackageFragmentArray = packages = project.getPackageFragments();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            L10nLocales locales;
            IPackageFragment packageFragment = iPackageFragmentArray[n2];
            if (packageFragment.getElementName().equals(model.getLocales().getPackage()) && (locales = model.getLocales()) != null) {
                Path destination = new Path(locales.getDestination());
                String defLocale = null;
                if (model.getLocales().getDefaultLocale() != null) {
                    defLocale = model.getLocales().getDefaultLocale().getName();
                }
                L10nApi.updateLocalizationApi(project.getProject(), packageFragment, (IPath)destination, defLocale);
                break;
            }
            ++n2;
        }
    }

    private static boolean updateLocalizationApi(IProject project, IPackageFragment _package, IPath _properties, String _defaultLocale) throws CoreException {
        ICompilationUnit resourcesClass = null;
        ICompilationUnit constantsClass = null;
        IPackageFragment targetPackage = _package;
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getName().equals(L10nApi.L10N_RESOURCES_CLASS) || resource.getName().equals(L10nApi.L10N_CONSTANTS_CLASS)) {
                    resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                return true;
            }
        });
        String code = L10nApi.buildL10nResourcesClass(_package, _properties, _defaultLocale);
        resourcesClass = targetPackage.createCompilationUnit(L10N_RESOURCES_CLASS, code, true, null);
        code = L10nApi.buildL10nConstantsClass(project, _package);
        constantsClass = targetPackage.createCompilationUnit(L10N_CONSTANTS_CLASS, code, true, null);
        return resourcesClass != null && constantsClass != null;
    }
}

