/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.internal.core.launching.StackTraceEntry;
import org.eclipse.mtj.internal.core.launching.StackTraceParserException;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StackTraceParser {
    protected IJavaProject project;

    public StackTraceParser(IJavaProject _project) {
        this.project = _project;
    }

    public abstract Stack<StackTraceEntry> parseStackTrace(Stack<StackTraceEntry> var1) throws StackTraceParserException;

    protected File getSourceFile(String className) throws StackTraceParserException {
        File classFile = null;
        try {
            ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
            projects.add(this.project);
            projects.addAll(Arrays.asList(Utils.getRequiredProjects(this.project)));
            for (IJavaProject javaProject : projects) {
                String[] paths = Utils.getJavaProjectSourceDirectories(javaProject);
                int i = 0;
                while (i < paths.length) {
                    File srcFolder = javaProject.getProject().getLocation().append(paths[i]).toFile();
                    classFile = this.findClassFile(srcFolder, className);
                    if (classFile != null) break;
                    ++i;
                }
                if (classFile == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            MTJLogger.log(4, e.getMessage(), e);
        }
        return classFile;
    }

    private File findClassFile(File srcFolder, String className) {
        File tempFile = null;
        int index = className.indexOf("$");
        if (index >= 0) {
            className = className.substring(0, index);
        }
        if ((index = className.lastIndexOf(".")) >= 0) {
            String packageName = className.substring(0, index);
            String[] packages = packageName.split(".");
            int i = 0;
            while (i < packages.length) {
                tempFile = new File(srcFolder, packages[i]);
                if (tempFile.exists()) {
                    srcFolder = tempFile;
                }
                ++i;
            }
        } else {
            tempFile = new File(srcFolder, String.valueOf(className) + ".java");
        }
        if (tempFile != null && !tempFile.exists()) {
            tempFile = null;
        }
        return tempFile;
    }
}

