/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.packaging.midp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.tools.AbstractJavaTool;
import org.eclipse.osgi.util.NLS;

public class ObfuscatorTool
extends AbstractJavaTool {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String MAIN_CLASS = "proguard.ProGuard";
    private static final String MAPPING_FILE_NAME = "pro_map.txt";
    private static final String NAME = "Obfuscator";
    private static final String PROGUARD_CFG_NAME = "proguard.cfg";
    private static final String SEEDS_FILE_NAME = "pro_seeds.txt";
    private static final String TEMPLATE_NAME = "config.pro";
    private File deploymentDirectory;
    private IMTJProject midletSuite;
    private File sourceJarFile;
    private File targetJarFile;

    public ObfuscatorTool(IMTJProject midletSuite, File sourceJarFile, File targetJarFile) {
        this.midletSuite = midletSuite;
        this.sourceJarFile = sourceJarFile;
        this.targetJarFile = targetJarFile;
    }

    private File copyConfigFileIfNecessary(File configFile) throws IOException {
        File newConfigFile = configFile;
        if (configFile.toString().indexOf(32) != -1) {
            newConfigFile = TemporaryFileManager.instance.createTempFile("proguard_", ".cfg");
            Utils.copyFile(configFile, newConfigFile, null);
        }
        return newConfigFile;
    }

    private File getDeploymentDirectory() throws CoreException {
        if (this.deploymentDirectory == null) {
            String dirName = MTJCore.getDeploymentDirectoryName();
            this.deploymentDirectory = this.getMidletSuiteFile(dirName);
        }
        return this.deploymentDirectory;
    }

    private File getDeploymentDirectoryFile(String name) throws CoreException {
        return new File(this.getDeploymentDirectory(), name);
    }

    private String getLibraryJarsClasspath() throws CoreException {
        IDevice device = this.midletSuite.getRuntimeList().getActiveMTJRuntime().getDevice();
        IDeviceClasspath deviceClasspath = device.getClasspath();
        return deviceClasspath.toString();
    }

    private File getMidletSuiteFile(String name) throws CoreException {
        IProject project = this.midletSuite.getJavaProject().getProject();
        File projectFile = project.getLocation().toFile();
        return new File(projectFile, name);
    }

    private File getProguardConfigFile() throws CoreException, IOException {
        File configFile = this.getDeploymentDirectoryFile(PROGUARD_CFG_NAME);
        File deployed = configFile.getParentFile();
        if (deployed != null && !deployed.exists()) {
            deployed.mkdir();
        }
        this.writeConfigFileContents(configFile);
        configFile = this.copyConfigFileIfNecessary(configFile);
        return configFile;
    }

    private String getProguardConfigFileTemplate() throws IOException {
        StringWriter sWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(sWriter);
        InputStream stream = this.getClass().getResourceAsStream(TEMPLATE_NAME);
        if (stream != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                    writer.flush();
                }
            }
            finally {
                reader.close();
            }
        }
        return sWriter.toString();
    }

    private String getProguardKeepParameters() {
        String[] keepExpressions;
        StringBuffer sb = new StringBuffer();
        PreferenceAccessor prefs = PreferenceAccessor.instance;
        String[] stringArray = keepExpressions = prefs.getProguardKeepExpressions(this.midletSuite.getProject());
        int n = keepExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            String expression = stringArray[n2];
            sb.append("-keep ").append(expression).append("\n");
            ++n2;
        }
        return sb.toString();
    }

    private Object getProguardOptions() {
        IProject project = this.midletSuite.getProject();
        PreferenceAccessor obfuscationPrefs = PreferenceAccessor.instance;
        String specifiedOptions = obfuscationPrefs.getSpecifiedProguardOptions(project);
        boolean useSpecified = obfuscationPrefs.isUseSpecifiedProguardOptions(project);
        return useSpecified ? specifiedOptions : obfuscationPrefs.getDefaultProguardOptions();
    }

    private String getQuotedOptions(String options) {
        StringBuffer quoted = new StringBuffer();
        Pattern p = Pattern.compile("([-]([^@])+)|([@]([^-])+)");
        Matcher m = p.matcher(options);
        while (m.find()) {
            String group = m.group().trim();
            if (group.startsWith("@")) {
                group = NLS.bind((String)"@\"{0}\"", (Object)group.substring(1));
            }
            quoted.append(group).append(" ");
        }
        return quoted.toString().trim();
    }

    private String getQuotedString(String string) {
        StringBuffer quoted = new StringBuffer();
        StringTokenizer st = new StringTokenizer(string, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf(32) != -1) {
                quoted.append("\"").append(token).append("\"");
            } else {
                quoted.append(token);
            }
            if (!st.hasMoreTokens()) continue;
            quoted.append(File.pathSeparatorChar);
        }
        return quoted.toString();
    }

    private String getTemplateWithSubstitutions(String template) throws CoreException {
        File mappingFile = this.getDeploymentDirectoryFile(MAPPING_FILE_NAME);
        File seedsFile = this.getDeploymentDirectoryFile(SEEDS_FILE_NAME);
        Object[] substitutions = new Object[]{this.getQuotedString(this.getLibraryJarsClasspath()), this.getQuotedString(this.sourceJarFile.toString()), this.getQuotedString(this.targetJarFile.toString()), this.getQuotedString(seedsFile.toString()), this.getQuotedString(mappingFile.toString()), this.getQuotedOptions(this.getProguardOptions().toString()), this.getProguardKeepParameters()};
        return NLS.bind((String)template, (Object[])substitutions);
    }

    private void writeConfigFileContents(File configFile) throws IOException, CoreException {
        FileWriter fWriter = new FileWriter(configFile);
        PrintWriter writer = new PrintWriter(fWriter);
        String template = this.getProguardConfigFileTemplate();
        String configurationFile = this.getTemplateWithSubstitutions(template);
        writer.println(configurationFile);
        writer.close();
    }

    protected String[] getArguments() {
        String[] args = null;
        try {
            File configFile = this.getProguardConfigFile();
            String argument = NLS.bind((String)"\"@{0}\"", (Object)configFile);
            args = new String[]{argument};
        }
        catch (Exception e) {
            MTJLogger.log(4, "getArguments", e);
        }
        return args;
    }

    protected String getClassName() {
        return MAIN_CLASS;
    }

    protected String[] getClasspath() {
        return new String[]{MTJCore.getProguardJarFile().toString()};
    }

    protected String getName() {
        return NAME;
    }

    protected String[] getVMArguments() {
        return EMPTY_STRING_ARRAY;
    }
}

