/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.project.midp.JavaMEClasspathContainer;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class JavaMEClasspathContainerInitializer
extends ClasspathContainerInitializer {
    private static Map<IDevice, JavaMEClasspathContainer> containers = new HashMap<IDevice, JavaMEClasspathContainer>();

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        String deviceGroup = containerPath.segment(1);
        String deviceName = containerPath.segment(2);
        try {
            IDevice device = MTJCore.getDeviceRegistry().getDevice(deviceGroup, deviceName);
            JavaMEClasspathContainer container = containers.get(device);
            if (device != null) {
                if (container == null) {
                    container = new JavaMEClasspathContainer(containerPath, device);
                    containers.put(device, container);
                }
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            } else {
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[1], null);
            }
        }
        catch (PersistenceException e) {
            MTJLogger.log(4, NLS.bind((String)Messages.JavaMEClasspathContainerInitializer_Could_not_load_JavaMEClasspath, (Object[])new Object[]{deviceGroup, deviceName}), e);
        }
    }
}

