/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.refactoring.BuildPropertiesChange;
import org.eclipse.osgi.util.NLS;

public class BuildPropertiesMoveParticipant
extends MoveParticipant {
    private IType type;
    private IFile file;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        if (checker != null && this.file.exists()) {
            IResourceChangeDescriptionFactory factory = checker.getDeltaFactory();
            factory.change(this.file);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.BuildPropertiesMoveParticipant_buildPropertiesChangeMessage);
        Object destination = this.getArguments().getDestination();
        if (destination instanceof IPackageFragment) {
            IPackageFragment newPackage = (IPackageFragment)destination;
            IPath oldPath = this.type.getResource().getProjectRelativePath();
            IPath newPath = newPackage.getResource().getProjectRelativePath();
            String newName = NLS.bind((String)"{0}/{1}.java", (Object[])new String[]{newPath.toString(), this.type.getElementName()});
            BuildPropertiesChange change = new BuildPropertiesChange(this.file, oldPath.toString(), newName);
            if (change.hasPropertiesChanges()) {
                compositeChange.add((Change)change);
            }
        }
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    public String getName() {
        return Messages.BuildPropertiesMoveParticipant_buildPropertiesMoveParticipantName;
    }

    protected boolean initialize(Object element) {
        boolean result = false;
        if (element instanceof IType) {
            this.type = (IType)element;
            IProject project = this.type.getJavaProject().getProject();
            this.file = project.getFile("build.properties");
            result = true;
        }
        return result;
    }
}

