/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.refactoring.BuildPropertiesChange;

public class BuildPropertiesPackageRenameParticipant
extends RenameParticipant {
    private IPackageFragment packageFragment;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = new CompositeChange(Messages.BuildPropertiesPackageRenameParticipant_buildPropertiesChangeMessage);
        this.createBuildPropertiesChanges(result);
        return result.getChildren().length > 0 ? result : null;
    }

    private void createBuildPropertiesChanges(CompositeChange compositeChange) {
        if (this.packageFragment == null) {
            return;
        }
        IResource resource = this.packageFragment.getResource();
        if (resource != null) {
            BuildPropertiesChange change;
            String oldName = this.packageFragment.getElementName().replace(".", "/");
            String newName = this.getArguments().getNewName().replace(".", "/");
            IPath oldPath = resource.getProjectRelativePath();
            Path newPath = new Path(oldPath.toString().replace(oldName, newName));
            IFile properties = resource.getProject().getFile("build.properties");
            if (properties.exists() && (change = new BuildPropertiesChange(properties, oldPath.toString(), newPath.toString())).hasPropertiesChanges()) {
                compositeChange.add((Change)change);
            }
        }
    }

    public String getName() {
        return Messages.BuildPropertiesPackageRenameParticipant_buildPropertiesPackageRenamePaticipant;
    }

    protected boolean initialize(Object element) {
        this.packageFragment = (IPackageFragment)element;
        return true;
    }
}

