/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.refactoring.BuildPropertiesChange;
import org.eclipse.osgi.util.NLS;

public class BuildPropertiesRenameParticipant
extends RenameParticipant {
    private IType type;
    private IFile file;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        if (checker != null && this.file.exists()) {
            IResourceChangeDescriptionFactory factory = checker.getDeltaFactory();
            factory.change(this.file);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = null;
        IResource resource = this.type.getResource();
        if (resource != null) {
            IPath resPath = resource.getProjectRelativePath();
            IPath newPath = resPath.removeLastSegments(1);
            newPath = newPath.append(NLS.bind((String)"{0}.java", (Object)this.getArguments().getNewName()));
            CompositeChange compositeChange = new CompositeChange(Messages.BuildPropertiesRenameParticipant_buildPropertiesChangeMessage);
            BuildPropertiesChange propertiesChange = new BuildPropertiesChange(this.file, resPath.toString(), newPath.toString());
            if (propertiesChange.hasPropertiesChanges()) {
                compositeChange.add((Change)propertiesChange);
                result = compositeChange;
            }
        }
        return result;
    }

    protected boolean initialize(Object element) {
        boolean result = false;
        if (element instanceof IType) {
            this.type = (IType)element;
            IProject project = this.type.getJavaProject().getProject();
            this.file = project.getFile("build.properties");
            result = true;
        }
        return result;
    }

    public String getName() {
        return Messages.BuildPropertiesRenameParticipant_buildPropertiesParticipantName;
    }
}

