/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.mtj.internal.core.refactoring.JadLaunchConfigProjectRenameChange;
import org.eclipse.mtj.internal.core.refactoring.RefactoringMessages;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class JadLaunchConfigProjectRenameParticipant
extends RenameParticipant {
    private IJavaProject fJavaProject;

    protected boolean initialize(Object element) {
        this.fJavaProject = (IJavaProject)element;
        return true;
    }

    public String getName() {
        return RefactoringMessages.JadLaunchConfigParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ILaunchConfiguration[] configs;
        ArrayList<JadLaunchConfigProjectRenameChange> changeList = new ArrayList<JadLaunchConfigProjectRenameChange>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = this.getRelatedJadLaunchConfigs(this.fJavaProject.getElementName());
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            changeList.add(new JadLaunchConfigProjectRenameChange(config, this.getArguments().getNewName()));
            ++n2;
        }
        int numOfChanges = changeList.size();
        if (numOfChanges == 0) {
            return null;
        }
        if (numOfChanges == 1) {
            return (Change)changeList.get(0);
        }
        return new CompositeChange(RefactoringMessages.JadLaunchConfigCompositeChange_name, changeList.toArray(new Change[changeList.size()]));
    }

    private ILaunchConfiguration[] getRelatedJadLaunchConfigs(String projectName) {
        if (projectName == null || projectName.trim().length() == 0) {
            return new ILaunchConfiguration[0];
        }
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getEmulatorConfigType());
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length) {
                String projectNameAttribute = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                boolean doJadLaunch = configs[i].getAttribute("mtj.do_jad_launch", false);
                boolean projectNameEqual = projectName.equals(projectNameAttribute);
                if (doJadLaunch && projectNameEqual) {
                    list.add(configs[i]);
                }
                ++i;
            }
            return list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
            return new ILaunchConfiguration[0];
        }
    }

    private ILaunchConfigurationType getEmulatorConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return configType;
    }
}

