/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.refactoring.MidletJadTextFileMidletChange;
import org.eclipse.mtj.internal.core.util.AbstractClasspathEntryVisitor;

class MidletJadFileChangesCollector
extends AbstractClasspathEntryVisitor {
    static final int MODE_RENAME = 1;
    static final int MODE_DELETE = 2;
    private int mode;
    private String oldName;
    private String newName;
    private CompositeChange change;

    public static CompositeChange collectChange(int mode, IType type, String newName, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = (IJavaProject)type.getAncestor(2);
        MidletJadFileChangesCollector collector = new MidletJadFileChangesCollector(mode, javaProject, type, newName);
        collector.addJavaProjectChanges(javaProject, monitor);
        collector.getRunner().run(javaProject, collector, monitor);
        return collector.getChange();
    }

    public MidletJadFileChangesCollector(int mode, IJavaProject javaProject, IType type, String newName) {
        this.mode = mode;
        this.newName = newName;
        this.oldName = type.getFullyQualifiedName();
        this.change = new CompositeChange("Update Application Descriptor Midlet References");
    }

    public CompositeChange getChange() {
        return this.change;
    }

    public boolean visitProject(IClasspathEntry entry, IJavaProject javaProject, IJavaProject classpathProject, IProgressMonitor monitor) throws CoreException {
        this.addJavaProjectChanges(javaProject, monitor);
        return true;
    }

    private void addJadFileChanges(IFile jadFile, IProgressMonitor monitor) throws CoreException {
        MidletJadTextFileMidletChange jadChange = new MidletJadTextFileMidletChange(this.mode, jadFile.getName(), jadFile, this.oldName, this.newName);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 3);
        Matcher matcher = jadChange.getMatcher(monitor);
        if (matcher.find()) {
            jadChange.initializeTextEdit(monitor);
            this.change.add((Change)jadChange);
        }
        subProgressMonitor.done();
    }

    private void addJavaProjectChanges(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        IFile jadFile;
        IMidletSuiteProject midletSuite;
        monitor.setTaskName("Creating Application Descriptor for " + javaProject.getElementName());
        if (this.isMidletSuite(javaProject) && (midletSuite = MidletSuiteFactory.getMidletSuiteProject(javaProject)) != null && (jadFile = midletSuite.getApplicationDescriptorFile()).exists()) {
            this.addJadFileChanges(jadFile, monitor);
        }
        monitor.worked(1);
    }

    private boolean isMidletSuite(IJavaProject javaProject) throws CoreException {
        return javaProject.getProject().hasNature("org.eclipse.mtj.core.nature");
    }
}

