/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class MidletJadTextFileMidletChange
extends TextFileChange {
    private static final String REGEX = "MIDlet-\\d+:.*?,.*?,(";
    private Matcher matcher;
    private Pattern matchPattern;
    private int mode;
    private String oldName;
    private String newName;

    public MidletJadTextFileMidletChange(int mode, String name, IFile file, String oldName, String newName) {
        super(name, file);
        this.mode = mode;
        this.oldName = oldName;
        this.newName = newName;
    }

    Matcher getMatcher(IProgressMonitor pm) throws CoreException {
        if (this.matcher == null) {
            pm.setTaskName("Initializing Regular Expression Matcher");
            String content = this.getCurrentContent(pm);
            this.matcher = this.getMatchPattern().matcher(content);
            pm.worked(1);
        }
        return this.matcher;
    }

    void initializeTextEdit(IProgressMonitor pm) throws CoreException {
        pm.setTaskName("Initializing Text Edit");
        DeleteEdit edit = null;
        Matcher matcher = this.getMatcher(pm);
        if (this.mode == 1) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            edit = new ReplaceEdit(start, end - start, this.newName);
        } else {
            int start = matcher.start();
            int end = matcher.end();
            edit = new DeleteEdit(start, end - start);
        }
        this.setEdit((TextEdit)edit);
        pm.worked(1);
    }

    private Pattern getMatchPattern() {
        if (this.matchPattern == null) {
            StringBuffer sb = new StringBuffer(REGEX).append(this.oldName).append(")");
            this.matchPattern = Pattern.compile(sb.toString());
        }
        return this.matchPattern;
    }
}

