/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.mtj.internal.core.refactoring.MidletJadFileChangesCollector;
import org.eclipse.mtj.internal.core.refactoring.RefactoringMessages;

public class MidletRenameParticipant
extends RenameParticipant {
    private IType type;

    protected boolean initialize(Object element) {
        this.type = (IType)element;
        return this.getArguments().getUpdateReferences();
    }

    public String getName() {
        return RefactoringMessages.UpdateApplicationDescriptor_refactoringParticipantName;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(pm, 5);
        subMonitor.setTaskName("Creating Application Descriptor Changes");
        String newName = this.getNewName();
        CompositeChange compositeChange = MidletJadFileChangesCollector.collectChange(1, this.type, newName, (IProgressMonitor)subMonitor);
        subMonitor.done();
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    private String getNewName() {
        StringBuffer sb = new StringBuffer();
        String packageName = this.type.getPackageFragment().getElementName();
        if (packageName != null && packageName.length() > 0) {
            sb.append(packageName).append(".");
        }
        sb.append(this.getArguments().getNewName());
        return sb.toString();
    }
}

