/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.mtj.internal.core.refactoring.MidLetsCollector;
import org.eclipse.mtj.internal.core.refactoring.MidletJadFileChangesCollector;
import org.eclipse.mtj.internal.core.refactoring.MidletJadTextFileMidletChange;
import org.eclipse.mtj.internal.core.refactoring.RefactoringMessages;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class PackageDeleteParticipant
extends DeleteParticipant {
    private IPackageFragment packageFragment;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(pm, 5);
        subMonitor.setTaskName("Creating Application Descriptor Changes");
        Set<IType> midlets = MidLetsCollector.collectMidletsInPackage(this.packageFragment, (IProgressMonitor)subMonitor);
        CompositeChange result = new CompositeChange(RefactoringMessages.RefectoringChangeName_PackageRenameParticipant);
        HashMap<IFile, MultiTextEdit> jadFileEditMap = new HashMap<IFile, MultiTextEdit>();
        for (IType iType : midlets) {
            Change[] changes;
            CompositeChange compositeChange = MidletJadFileChangesCollector.collectChange(2, iType, null, (IProgressMonitor)subMonitor);
            Change[] changeArray = changes = compositeChange.getChildren();
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                MidletJadTextFileMidletChange jadChange = (MidletJadTextFileMidletChange)change;
                TextEdit edit = jadChange.getEdit();
                IFile jadFile = jadChange.getFile();
                MultiTextEdit multiTextEdit = (MultiTextEdit)jadFileEditMap.get(jadFile);
                if (multiTextEdit == null) {
                    multiTextEdit = new MultiTextEdit();
                    jadFileEditMap.put(jadFile, multiTextEdit);
                }
                multiTextEdit.addChild(edit);
                ++n2;
            }
        }
        for (Map.Entry entry : jadFileEditMap.entrySet()) {
            IFile jadFile = (IFile)entry.getKey();
            TextFileChange textFileChange = new TextFileChange(jadFile.getName(), jadFile);
            textFileChange.setEdit((TextEdit)entry.getValue());
            result.add((Change)textFileChange);
        }
        subMonitor.done();
        return result.getChildren().length > 0 ? result : null;
    }

    public String getName() {
        return RefactoringMessages.UpdateApplicationDescriptor_refactoringParticipantName;
    }

    protected boolean initialize(Object element) {
        this.packageFragment = (IPackageFragment)element;
        return true;
    }
}

