/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceClasspath
implements IDeviceClasspath {
    private ArrayList<ILibrary> entries = new ArrayList();

    @Override
    public void addEntry(ILibrary pathEntry) {
        this.entries.add(pathEntry);
    }

    @Override
    public List<IClasspathEntry> asClasspathEntries() {
        List<ILibrary> allEntries = this.getEntries();
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(allEntries.size());
        int i = 0;
        while (i < allEntries.size()) {
            cpEntries.add(allEntries.get(i).toClasspathEntry());
            ++i;
        }
        return cpEntries;
    }

    @Override
    public boolean equals(IDeviceClasspath deviceClasspath) {
        List<ILibrary> myEntries = this.getEntries();
        List<ILibrary> otherEntries = deviceClasspath.getEntries();
        boolean equals = myEntries.size() == otherEntries.size();
        int i = 0;
        while (equals && i < myEntries.size()) {
            equals = myEntries.get(i).equals(otherEntries.get(i));
            ++i;
        }
        return equals;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof DeviceClasspath) {
            equals = this.equals((IDeviceClasspath)obj);
        }
        return equals;
    }

    @Override
    public List<ILibrary> getEntries() {
        return this.entries;
    }

    @Override
    public int hashCode() {
        List<ILibrary> allEntries = this.getEntries();
        int hashCode = allEntries.size() << 24;
        for (ILibrary allEntrie : allEntries) {
            hashCode ^= allEntrie.hashCode();
        }
        return hashCode;
    }

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        this.entries.clear();
        int entryCount = persistenceProvider.loadInteger("entryCount");
        int i = 0;
        while (i < entryCount) {
            this.entries.add((ILibrary)persistenceProvider.loadPersistable("entry" + i));
            ++i;
        }
    }

    @Override
    public void removeEntry(ILibrary library) {
        this.entries.remove(library);
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        persistenceProvider.storeInteger("entryCount", this.entries.size());
        int i = 0;
        for (ILibrary lib : this.entries) {
            persistenceProvider.storePersistable("entry" + i++, lib);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        List<ILibrary> allEntries = this.getEntries();
        int i = 0;
        while (i < allEntries.size()) {
            if (i != 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(allEntries.get(i).toFile());
            ++i;
        }
        return sb.toString();
    }
}

