/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatchCache;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DeviceMatchCache
implements IPersistable,
IDeviceMatchCache {
    private static final String ELEMENT_DEVICECACHE = "devicematchcache";
    private static final String DEVICECACHE_FILENAME = "devicematchcache.xml";
    private static Hashtable<String, String[]> deviceCache = null;
    private static IDeviceMatchCache instance = null;

    public static IDeviceMatchCache getInstance() {
        if (instance == null) {
            instance = new DeviceMatchCache();
        }
        return instance;
    }

    private File getComponentStoreFile() {
        IPath pluginStatePath = MTJCore.getMTJCore().getStateLocation();
        IPath storePath = pluginStatePath.append(DEVICECACHE_FILENAME);
        return storePath.toFile();
    }

    private void loadCache() throws PersistenceException {
        File storeFile = this.getComponentStoreFile();
        if (storeFile.exists()) {
            try {
                Document document = XMLUtils.readDocument(storeFile);
                if (document == null) {
                    return;
                }
                Element rootXmlElement = document.getDocumentElement();
                if (!rootXmlElement.getNodeName().equals(ELEMENT_DEVICECACHE)) {
                    return;
                }
                XMLPersistenceProvider pprovider = new XMLPersistenceProvider(document);
                this.loadUsing(pprovider);
            }
            catch (ParserConfigurationException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        } else {
            deviceCache = new Hashtable();
        }
    }

    private void saveCache() throws PersistenceException {
        XMLPersistenceProvider pprovider = new XMLPersistenceProvider(ELEMENT_DEVICECACHE);
        this.storeUsing(pprovider);
        try {
            XMLUtils.writeDocument(this.getComponentStoreFile(), pprovider.getDocument());
        }
        catch (TransformerException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    public String[] getValueFromCache(String key) {
        if (deviceCache == null) {
            try {
                this.loadCache();
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (deviceCache.containsKey(key)) {
            return deviceCache.get(key);
        }
        return null;
    }

    public String createKey(String deviceGroup, String deviceName) {
        return new String(String.valueOf(deviceGroup) + "/" + deviceName);
    }

    public void saveInCache(String key, String[] value) {
        try {
            if (deviceCache == null) {
                this.loadCache();
            }
            deviceCache.put(key, value);
            this.saveCache();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public String[] createValue(IDevice d) {
        return new String[]{d.getSDKName(), d.getName()};
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        int count = persistenceProvider.loadInteger("entries");
        deviceCache = new Hashtable(2 * count);
        int i = 0;
        while (i < count) {
            String key = persistenceProvider.loadString("key" + i);
            String value = persistenceProvider.loadString("value" + i);
            deviceCache.put(key, value.split("/"));
            ++i;
        }
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        persistenceProvider.storeInteger("entries", deviceCache.size());
        int i = 0;
        Enumeration<String> e = deviceCache.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String[] v = deviceCache.get(key);
            String value = String.valueOf(v[0]) + "/" + v[1];
            persistenceProvider.storeString("key" + i, key);
            persistenceProvider.storeString("value" + i, value);
            ++i;
        }
    }
}

