/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.internal.core.Trace;

public class JavadocDetector {
    private static final String PACKAGE_LIST = "package-list";

    public URL detectJavadoc(ILibrary library) {
        boolean trace = Trace.isOptionEnabled(Trace.JAVADOC_DETECT_PERF);
        long enterTime = 0L;
        if (trace) {
            enterTime = System.currentTimeMillis();
        }
        URL retURL = this.searchForJavaDoc(library);
        if (trace) {
            long elapsed = System.currentTimeMillis() - enterTime;
            Trace.trace(Trace.JAVADOC_DETECT_PERF, "Detected javadoc for ", library.toString(), " in ", elapsed, "ms");
        }
        return retURL;
    }

    private URL searchForJavaDoc(ILibrary library) {
        URL foundURL = null;
        File[] rootDirs = this.getDefaultDocRootDirectories(library);
        if (rootDirs != null) {
            File[] fileArray = rootDirs;
            int n = rootDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File docDir = fileArray[n2];
                foundURL = this.searchForLibraryDoc(docDir, library);
                if (foundURL != null) break;
                ++n2;
            }
        }
        return foundURL;
    }

    private File[] getDefaultDocRootDirectories(ILibrary library) {
        if (library == null) {
            return null;
        }
        ArrayList<File> docfiles = new ArrayList<File>();
        File parentDir = library.toFile().getParentFile();
        int i = 0;
        while (i < 5 && parentDir != null) {
            File[] tmpDocfiles;
            File[] fileArray = tmpDocfiles = parentDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().indexOf("doc") != -1;
                }
            });
            int n = tmpDocfiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                docfiles.add(file);
                ++n2;
            }
            parentDir = parentDir.getParentFile();
            ++i;
        }
        if (docfiles.size() > 0) {
            return docfiles.toArray(new File[0]);
        }
        return null;
    }

    private URL searchForLibraryDoc(File parentDir, ILibrary library) {
        if (library instanceof IMIDPLibrary) {
            File[] javadocDirs = parentDir.listFiles(new FileFilter(){

                public boolean accept(File folder) {
                    File packageList;
                    File indexFile;
                    return folder.isDirectory() && (indexFile = new File(folder, "index.html")).isFile() && (packageList = new File(folder, JavadocDetector.PACKAGE_LIST)).isFile();
                }
            });
            if (javadocDirs.length > 0) {
                try {
                    JarFile jar = new JarFile(library.toFile());
                    boolean found = false;
                    IMIDPLibrary midpLib = (IMIDPLibrary)library;
                    boolean mustHaveJavaLang = midpLib.hasProfile() || midpLib.hasConfiguration();
                    Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Searching javadocs for ", midpLib);
                    int i = 0;
                    while (i < javadocDirs.length) {
                        String libraryName;
                        File pList = new File(javadocDirs[i], PACKAGE_LIST);
                        boolean foundJavaLang = false;
                        BufferedReader reader = new BufferedReader(new FileReader(pList));
                        String s = reader.readLine();
                        while (s != null) {
                            if (s.startsWith("#")) {
                                s = reader.readLine();
                                continue;
                            }
                            if (mustHaveJavaLang && !foundJavaLang && "java.lang".equals(s.trim())) {
                                Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "java.lang entry found in line ", s, " package-list is ", pList);
                                foundJavaLang = true;
                            }
                            if (jar.getEntry(s.replace('.', '/')) == null) {
                                found = false;
                                break;
                            }
                            s = reader.readLine();
                            found = true;
                            if (!mustHaveJavaLang || foundJavaLang) continue;
                            found = false;
                        }
                        if (found) {
                            Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Found javadocs for ", midpLib, " in ", javadocDirs[i]);
                            return javadocDirs[i].toURI().toURL();
                        }
                        String libFileName = library.toFile().getName();
                        int dotIdx = libFileName.lastIndexOf(46);
                        String libName = dotIdx > -1 ? libFileName.substring(0, dotIdx) : libFileName;
                        String pathname = javadocDirs[i].getName().toLowerCase();
                        if (pathname.startsWith(libraryName = libName.toLowerCase()) || libraryName.startsWith(pathname)) {
                            return javadocDirs[i].toURI().toURL();
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error while matchin javadocs", (Throwable)e));
                }
            }
            File[] subdirectories = parentDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            URL url = null;
            int i = 0;
            while (i < subdirectories.length && url == null) {
                url = this.searchForLibraryDoc(subdirectories[i], library);
                ++i;
            }
            return url;
        }
        return null;
    }
}

