/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sign;

import com.ibm.icu.text.SimpleDateFormat;
import de.schlichtherle.io.FileInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyPairInfo;
import org.eclipse.mtj.internal.core.sign.KeyStoreEntry;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKeyStoreManager
implements IKeyStoreManager {
    private static final String FILE = "-file";
    private static final String SIGALG_VALUE = "SHA1withRSA";
    private static final String SIGALG = "-sigalg";
    private static final String KEYPASS = "-keypass";
    private static final String DNAME = "-dname";
    private static final String ALIAS = "-alias";
    private static final String KEYALG_VALUE = "RSA";
    private static final String KEYALG = "-keyalg";
    private static final String STORETYPE = "-storetype";
    private static final String COM_SUN_CRYPTO_PROVIER_NAME = "com.sun.crypto.provier.{0}";
    private static final String PROVIDER = "-provider";
    private static final String NEW = "-new";
    private static final String STOREPASS = "-storepass";
    private static final String KEYSTORE = "-keystore";
    private static final String STOREPASSWD = "-storepasswd";
    private static final String KEYTOOL = "keytool";
    private static final Object INVALID_PASSWORD_ERROR_1 = "Keystore was tampered with, or password was incorrect";
    private static final Object INVALID_PASSWORD_ERROR_2 = "Given final block not properly padded";
    private File ksFile;
    private String ksPassword;
    private String ksType;
    private String ksProvider;

    public DefaultKeyStoreManager(File _ksFile, String _ksPassword) {
        if (_ksFile == null) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_keyStoreNotNull);
        }
        if (!_ksFile.isFile()) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_invalidKeystoreFile);
        }
        if (_ksPassword == null) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_keystorePasswordNotNull);
        }
        if (_ksPassword.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.DefaultKeyStoreManager_keystorePasswordEmpty);
        }
        this.ksType = KeyStore.getDefaultType();
        this.ksFile = _ksFile;
        this.ksPassword = _ksPassword;
    }

    @Override
    public void setProvider(String _provider) {
        if (_provider != null && _provider.length() > 0) {
            this.ksProvider = _provider;
        }
    }

    @Override
    public void setKeystoreType(String _type) {
        if (_type != null && _type.length() > 0) {
            this.ksType = _type;
        }
    }

    @Override
    public List<KeyStoreEntry> getEntries() throws KeyStoreManagerException {
        ArrayList<KeyStoreEntry> result = new ArrayList<KeyStoreEntry>();
        try {
            KeyStore keyStore = this.openKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                KeyStoreEntry.Type type = null;
                if (keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                    type = KeyStoreEntry.Type.CERIFICATE;
                } else if (keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                    type = KeyStoreEntry.Type.KEY_PAIR;
                }
                if (alias == null || type == null) continue;
                result.add(new KeyStoreEntry(alias, type));
            }
        }
        catch (KeyStoreException e) {
            String message = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToAccessKeystoreContent, (Object)e.getMessage());
            throw new KeyStoreManagerException(message);
        }
        return result;
    }

    @Override
    public String getCertificateInformation(KeyStoreEntry entry) throws KeyStoreManagerException {
        String alias = entry.getAlias();
        String data = null;
        try {
            KeyStore keyStore = this.openKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String current = aliases.nextElement();
                if (!current.equals(alias)) continue;
                Certificate certificate = keyStore.getCertificate(alias);
                SimpleDateFormat format = new SimpleDateFormat("MMM dd, yyyy");
                String fingerprint = this.buildFingerPrint(certificate.getEncoded());
                data = NLS.bind((String)Messages.DefaultKeyStoreManager_certificateInfoFormat, (Object)format.format(keyStore.getCreationDate(alias)), (Object)fingerprint);
                break;
            }
        }
        catch (KeyStoreException e) {
            String message = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToAccessKeystoreContent, (Object)e.getMessage());
            throw new KeyStoreManagerException(message);
        }
        catch (CertificateEncodingException e) {
            String message = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToGetEncodedCertificate, (Object)e.getMessage());
            throw new KeyStoreManagerException(message);
        }
        catch (NoSuchAlgorithmException e) {
            String message = NLS.bind((String)Messages.DefaultKeyStoreManager_unableToCreateMD5Fingerprint, (Object)e.getMessage());
            throw new KeyStoreManagerException(message);
        }
        return data;
    }

    @Override
    public void changeKeystorePassword(String password) throws KeyStoreManagerException {
        LinkedList<String> command = new LinkedList<String>();
        command.add(KEYTOOL);
        command.add(STOREPASSWD);
        command.add(KEYSTORE);
        command.add(this.ksFile.getAbsolutePath());
        command.add(STOREPASS);
        command.add(this.ksPassword);
        command.add(NEW);
        command.add(password);
        if (this.ksProvider != null) {
            command.add(PROVIDER);
            command.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            command.add(STORETYPE);
            command.add(this.ksType);
        }
        this.keytool(command.toArray(new String[0]));
        this.ksPassword = password;
    }

    @Override
    public void generateKeyPair(KeyPairInfo keyPairInfo) throws KeyStoreManagerException {
        LinkedList<String> command = new LinkedList<String>();
        command.add(KEYTOOL);
        command.add("-genkey");
        command.add(KEYALG);
        command.add(KEYALG_VALUE);
        command.add(KEYSTORE);
        command.add(this.ksFile.getAbsolutePath());
        command.add(STOREPASS);
        command.add(this.ksPassword);
        command.add(ALIAS);
        command.add(keyPairInfo.getAlias());
        command.add(DNAME);
        command.add(keyPairInfo.toString());
        command.add(KEYPASS);
        command.add(keyPairInfo.getPassword());
        if (this.ksProvider != null) {
            command.add(PROVIDER);
            command.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            command.add(STORETYPE);
            command.add(this.ksType);
        }
        this.keytool(command.toArray(new String[0]));
    }

    @Override
    public void deleteEntry(KeyStoreEntry entry) throws KeyStoreManagerException {
        LinkedList<String> command = new LinkedList<String>();
        command.add(KEYTOOL);
        command.add("-delete");
        command.add(KEYSTORE);
        command.add(this.ksFile.getAbsolutePath());
        command.add(STOREPASS);
        command.add(this.ksPassword);
        command.add(ALIAS);
        command.add(entry.getAlias());
        if (this.ksProvider != null) {
            command.add(PROVIDER);
            command.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            command.add(STORETYPE);
            command.add(this.ksType);
        }
        this.keytool(command.toArray(new String[0]));
    }

    @Override
    public void generateCSR(String alias, String password, String destination) throws KeyStoreManagerException {
        LinkedList<String> command = new LinkedList<String>();
        command.add(KEYTOOL);
        command.add("-certreq");
        command.add(SIGALG);
        command.add(SIGALG_VALUE);
        command.add(KEYSTORE);
        command.add(this.ksFile.getAbsolutePath());
        command.add(STOREPASS);
        command.add(this.ksPassword);
        command.add(ALIAS);
        command.add(alias);
        command.add(KEYPASS);
        command.add(password);
        command.add(FILE);
        command.add(destination);
        if (this.ksProvider != null) {
            command.add(PROVIDER);
            command.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            command.add(STORETYPE);
            command.add(this.ksType);
        }
        try {
            this.keytool(command.toArray(new String[0]));
        }
        catch (KeyStoreManagerException e) {
            File csrFile = new File(destination);
            if (csrFile.exists()) {
                csrFile.delete();
            }
            throw e;
        }
    }

    @Override
    public void importCertificate(String alias, String password, String certPath) throws KeyStoreManagerException {
        LinkedList<String> command = new LinkedList<String>();
        command.add(KEYTOOL);
        command.add("-import");
        command.add("-noprompt");
        command.add("-trustcacerts");
        command.add(KEYSTORE);
        command.add(this.ksFile.getAbsolutePath());
        command.add(STOREPASS);
        command.add(this.ksPassword);
        command.add(ALIAS);
        command.add(alias);
        command.add(KEYPASS);
        command.add(password);
        command.add(FILE);
        command.add(certPath);
        if (this.ksProvider != null) {
            command.add(PROVIDER);
            command.add(NLS.bind((String)COM_SUN_CRYPTO_PROVIER_NAME, (Object)this.ksProvider));
        }
        if (this.ksType != null) {
            command.add(STORETYPE);
            command.add(this.ksType);
        }
        this.keytool(command.toArray(new String[0]));
    }

    private void keytool(String[] command) throws KeyStoreManagerException {
        try {
            Process process = Runtime.getRuntime().exec(command);
            while (true) {
                try {
                    int exit = process.waitFor();
                    if (exit != 0) {
                        String message = this.getProcessErrorMessage(process);
                        throw new KeyStoreManagerException(this.parseKeyToolError(new Exception(message)));
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new KeyStoreManagerException(this.parseKeyToolError(e));
        }
    }

    private String getProcessErrorMessage(Process process) throws IOException {
        BufferedReader inStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer buffer = new StringBuffer();
        String result = Messages.DefaultKeyStoreManager_22;
        String line = null;
        while ((line = inStream.readLine()) != null) {
            buffer.append(line.trim());
            if (line != null) continue;
        }
        Pattern pattern = Pattern.compile("[keytool error:].*[:]");
        String[] array = pattern.split(buffer.toString());
        if (array.length == 2) {
            result = array[1];
        }
        return result;
    }

    private String buildFingerPrint(byte[] encoded) throws NoSuchAlgorithmException {
        byte[] digest;
        StringBuffer buffer = new StringBuffer();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] byArray = digest = md.digest(encoded);
        int n = digest.length;
        int n2 = 0;
        while (n2 < n) {
            String hex;
            byte b = byArray[n2];
            if (buffer.length() > 0) {
                buffer.append(":");
            }
            buffer.append((hex = Integer.toHexString(b & 0xFF).toUpperCase()).length() > 1 ? hex : NLS.bind((String)"0{0}", (Object)hex));
            ++n2;
        }
        return buffer.toString();
    }

    private KeyStore openKeyStore() throws KeyStoreManagerException {
        KeyStore keyStore = null;
        try {
            keyStore = this.ksProvider != null ? KeyStore.getInstance(this.ksType, this.ksProvider) : KeyStore.getInstance(this.ksType);
            keyStore.load((InputStream)new FileInputStream(this.ksFile), this.ksPassword.toCharArray());
        }
        catch (Exception e) {
            String message = this.parseKeyToolError(e);
            throw new KeyStoreManagerException(NLS.bind((String)Messages.DefaultKeyStoreManager_unableToOpenKeystore, (Object)message));
        }
        return keyStore;
    }

    private String parseKeyToolError(Exception e) {
        String message = e.getMessage().trim();
        if (message.equals(INVALID_PASSWORD_ERROR_1)) {
            message = Messages.DefaultKeyStoreManager_invalidKsPassword;
        } else if (message.equals(INVALID_PASSWORD_ERROR_2)) {
            message = Messages.DefaultKeyStoreManager_InvalidKeyPassword;
        }
        return message;
    }
}

