/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sign;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.sign.PermissionsGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsGroupsRegistry
implements IRegistryChangeListener {
    private static final String NAME = "name";
    private static final String EXT_SECURITY_PERMISSION = "securitypermission";
    private static final String EXT_ID = "org.eclipse.mtj.core.securitypermission";
    private List<PermissionsGroup> permissions;
    private static PermissionsGroupsRegistry instance;

    public static synchronized PermissionsGroupsRegistry getInstance() {
        if (instance == null) {
            instance = new PermissionsGroupsRegistry();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)instance);
        }
        return instance;
    }

    private PermissionsGroupsRegistry() {
        IExtensionRegistry registry = null;
        IConfigurationElement[] extensions = null;
        this.permissions = new ArrayList<PermissionsGroup>();
        registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            String className = extension.getAttribute(NAME);
            List<String> classPermissions = this.getClassPermissions(extension.getChildren());
            this.permissions.add(new PermissionsGroup(className, classPermissions));
            ++n2;
        }
    }

    private List<String> getClassPermissions(IConfigurationElement[] _elements) {
        ArrayList<String> permissions = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = _elements;
        int n = _elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String permission = element.getAttribute(NAME);
            permissions.add(permission);
            ++n2;
        }
        return permissions;
    }

    public List<PermissionsGroup> getPermissions() {
        ArrayList<PermissionsGroup> copy = new ArrayList<PermissionsGroup>();
        copy.addAll(this.permissions);
        return copy;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        String plugin = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IExtensionDelta[] deltas = event.getExtensionDeltas(plugin, EXT_SECURITY_PERMISSION);
        int i = 0;
        while (i < deltas.length) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = deltas[i].getExtension().getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String className = element.getAttribute(NAME);
                List<String> classPermissions = this.getClassPermissions(element.getChildren());
                if (deltas[i].getKind() == 1) {
                    this.permissions.add(new PermissionsGroup(className, classPermissions));
                } else {
                    int index = 0;
                    while (i < this.permissions.size()) {
                        if (className.equals(this.permissions.get(index).getClassName())) {
                            this.permissions.remove(index);
                            break;
                        }
                        ++index;
                    }
                }
                ++n2;
            }
            ++i;
        }
    }
}

