/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.internal.core.symbol.SymbolUtils;
import org.eclipse.osgi.util.NLS;

public class Symbol
implements ISymbol,
Cloneable {
    public static final int TYPE_ABILITY = 0;
    public static final int TYPE_CONFIG = 1;
    private String name;
    private int type;
    private String value;

    Symbol(String name) {
        this.name = name;
        this.value = "true";
    }

    public Symbol(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Symbol(String name, String value, int type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getSafeValue() {
        return SymbolUtils.getSafeSymbolValue(this.value);
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String identifier) {
        this.name = identifier;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Symbol other = (Symbol)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return NLS.bind((String)"{0}: {1}={2}", (Object[])new Object[]{this.getClass().getSimpleName(), this.name, this.value});
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Symbol(this.getName(), this.getValue(), this.getType());
    }
}

