/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.core.symbol.ISymbolSetFactory;
import org.eclipse.mtj.internal.core.symbol.Symbol;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolSetFactory
implements ISymbolSetFactory {
    public static final String J2MEPOLISH_FILENAME_XML_DEVICES = "devices.xml";
    public static final String J2MEPOLISH_FILENAME_XML_GROUPS = "groups.xml";
    private static final SymbolSetFactory instance = new SymbolSetFactory();

    public static ISymbolSetFactory getInstance() {
        return instance;
    }

    @Override
    public ISymbol createSymbol(String name, String value) {
        Symbol s = new Symbol(name, value);
        return s;
    }

    @Override
    public ISymbolSet createSymbolSet(String name) {
        SymbolSet ss = new SymbolSet();
        ss.setName(name);
        return ss;
    }

    @Override
    public List<ISymbolSet> createSymbolSetFromDataBase(String type, IPath databasePath, IProgressMonitor monitor) throws IOException {
        List<ISymbolSet> result = null;
        if (type.equals("org.eclipse.mtj.davicedb.j2mepolish.antennajar")) {
            result = this.handleAntennaJAR(monitor, databasePath);
        } else if (type.equals("org.eclipse.mtj.davicedb.j2mepolish.file")) {
            result = this.handleFiles(monitor, databasePath);
        }
        return result;
    }

    @Override
    public ISymbolSet createSymbolSetFromDevice(IDevice device) {
        ISymbolSet ss = SymbolUtils.createSymbolSet(device);
        return ss;
    }

    @Override
    public ISymbolSet createSymbolSetFromProperties(Properties properties) {
        ISymbolSet ss = SymbolUtils.createSymbolSet(properties);
        return ss;
    }

    private List<ISymbolSet> handleAntennaJAR(IProgressMonitor monitor, IPath databasePath) throws IOException {
        InputStream groupsInputStream;
        InputStream devicesInputStream;
        JarFile antennaFileJar;
        List<ISymbolSet> result;
        block18: {
            result = null;
            antennaFileJar = null;
            devicesInputStream = null;
            groupsInputStream = null;
            try {
                antennaFileJar = new JarFile(databasePath.toFile());
                Enumeration<JarEntry> e = antennaFileJar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (entry.getName().toLowerCase().equals(J2MEPOLISH_FILENAME_XML_DEVICES)) {
                        devicesInputStream = antennaFileJar.getInputStream(entry);
                    }
                    if (!entry.getName().toLowerCase().equals(J2MEPOLISH_FILENAME_XML_GROUPS)) continue;
                    groupsInputStream = antennaFileJar.getInputStream(entry);
                }
                if (devicesInputStream == null || groupsInputStream == null) break block18;
                try {
                    result = SymbolUtils.importFromJ2MEPolishFormat(monitor, devicesInputStream, groupsInputStream);
                }
                catch (Exception exception) {
                    throw new IOException();
                }
            }
            catch (Throwable throwable) {
                try {
                    if (antennaFileJar != null) {
                        antennaFileJar.close();
                    }
                    if (devicesInputStream != null) {
                        devicesInputStream.close();
                    }
                    if (groupsInputStream != null) {
                        groupsInputStream.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            if (antennaFileJar != null) {
                antennaFileJar.close();
            }
            if (devicesInputStream != null) {
                devicesInputStream.close();
            }
            if (groupsInputStream != null) {
                groupsInputStream.close();
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private List<ISymbolSet> handleFiles(IProgressMonitor monitor, IPath databasePath) throws IOException {
        List<ISymbolSet> result = null;
        InputStream devicesInputStream = null;
        InputStream groupsInputStream = null;
        try {
            try {
                devicesInputStream = new FileInputStream(new File(databasePath + File.separator + J2MEPOLISH_FILENAME_XML_DEVICES));
                groupsInputStream = new FileInputStream(new File(databasePath + File.separator + J2MEPOLISH_FILENAME_XML_GROUPS));
                result = SymbolUtils.importFromJ2MEPolishFormat(monitor, devicesInputStream, groupsInputStream);
            }
            catch (IOException e) {
                throw e;
            }
            catch (PersistenceException persistenceException) {
                throw new IOException();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException();
            }
            catch (SAXException sAXException) {
                throw new IOException();
            }
        }
        finally {
            if (devicesInputStream != null) {
                devicesInputStream.close();
            }
            if (groupsInputStream != null) {
                groupsInputStream.close();
            }
        }
        return result;
    }
}

