/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.IModel;
import org.eclipse.mtj.internal.core.text.DocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.DocumentTextNode;
import org.eclipse.mtj.internal.core.text.DocumentXMLNode;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.util.MTJTextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentElementNode
extends DocumentXMLNode
implements IDocumentElementNode {
    public static final String ATTRIBUTE_VALUE_ENCODING = "UTF-8";
    public static final String ATTRIBUTE_VALUE_FALSE = "false";
    public static final String ATTRIBUTE_VALUE_TRUE = "true";
    private static final long serialVersionUID = 1L;
    private TreeMap<String, IDocumentAttributeNode> fAttributes;
    private ArrayList<IDocumentElementNode> fChildren = new ArrayList();
    private transient int fIndent = 0;
    private transient boolean fIsErrorNode = false;
    private transient int fLength = -1;
    private transient int fOffset = -1;
    private transient IDocumentElementNode fParent = null;
    private transient IDocumentElementNode fPreviousSibling = null;
    private String fTag = null;
    private IDocumentTextNode fTextNode = null;

    public DocumentElementNode() {
        this.fAttributes = new TreeMap();
    }

    @Override
    public void addChildNode(IDocumentElementNode child) {
        this.addChildNode(child, this.fChildren.size());
    }

    @Override
    public void addChildNode(IDocumentElementNode child, int position) {
        this.fChildren.add(position, child);
        child.setParentNode(this);
        this.linkNodeWithSiblings(child);
    }

    @Override
    public void addTextNode(IDocumentTextNode textNode) {
        this.fTextNode = textNode;
    }

    @Override
    public boolean canTerminateStartTag() {
        return !this.hasXMLChildren() && !this.hasXMLContent() && this.isLeafNode();
    }

    @Override
    public IDocumentElementNode getChildAt(int index) {
        if (index < this.fChildren.size()) {
            return this.fChildren.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.fChildren.size();
    }

    @Override
    public IDocumentElementNode[] getChildNodes() {
        return this.fChildren.toArray(new IDocumentElementNode[this.fChildren.size()]);
    }

    @Override
    public ArrayList<IDocumentElementNode> getChildNodesList() {
        return this.fChildren;
    }

    @Override
    public IDocumentAttributeNode getDocumentAttribute(String name) {
        return this.fAttributes.get(name);
    }

    @Override
    public String getIndent() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.fIndent) {
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getLineIndent() {
        return this.fIndent;
    }

    @Override
    public IDocumentAttributeNode[] getNodeAttributes() {
        ArrayList<IDocumentAttributeNode> list = new ArrayList<IDocumentAttributeNode>();
        Iterator<IDocumentAttributeNode> iter = this.fAttributes.values().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list.toArray(new IDocumentAttributeNode[list.size()]);
    }

    @Override
    public int getNodeAttributesCount() {
        IDocumentAttributeNode[] attributes;
        int count = 0;
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = attributes = this.getNodeAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode attribute = iDocumentAttributeNodeArray[n2];
            if (this.isDefined(attribute)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    public TreeMap<String, IDocumentAttributeNode> getNodeAttributesMap() {
        return this.fAttributes;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public IDocumentElementNode getParentNode() {
        return this.fParent;
    }

    @Override
    public IDocumentElementNode getPreviousSibling() {
        return this.fPreviousSibling;
    }

    @Override
    public IDocumentTextNode getTextNode() {
        return this.fTextNode;
    }

    @Override
    public String getXMLAttributeValue(String name) {
        IDocumentAttributeNode attribute = this.fAttributes.get(name);
        if (attribute == null) {
            return null;
        }
        return attribute.getAttributeValue();
    }

    @Override
    public String getXMLContent() {
        IDocumentTextNode node = this.getTextNode();
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    @Override
    public String getXMLTagName() {
        return this.fTag;
    }

    @Override
    public int getXMLType() {
        return 0;
    }

    @Override
    public boolean hasXMLAttributes() {
        return this.getNodeAttributesCount() != 0;
    }

    @Override
    public boolean hasXMLChildren() {
        return this.getChildCount() != 0;
    }

    @Override
    public boolean hasXMLContent() {
        return this.isDefined(this.fTextNode);
    }

    @Override
    public int indexOf(IDocumentElementNode child) {
        return this.fChildren.indexOf(child);
    }

    @Override
    public boolean isContentCollapsed() {
        return false;
    }

    @Override
    public boolean isErrorNode() {
        return this.fIsErrorNode;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public void reconnect(IDocumentElementNode parent, IModel model) {
        this.reconnectDocument();
        this.reconnectParent(parent);
        this.reconnectPreviousSibling();
        this.reconnectText();
        this.reconnectAttributes();
        this.reconnectChildren(model);
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode child) {
        int index = this.fChildren.indexOf(child);
        if (index != -1) {
            this.fChildren.remove(child);
            if (index < this.fChildren.size()) {
                IDocumentElementNode prevSibling = index == 0 ? null : this.fChildren.get(index - 1);
                this.fChildren.get(index).setPreviousSibling(prevSibling);
            }
            return child;
        }
        return null;
    }

    @Override
    public IDocumentElementNode removeChildNode(int index) {
        if (index < 0 || index >= this.fChildren.size()) {
            return null;
        }
        IDocumentElementNode child = this.fChildren.get(index);
        this.fChildren.remove(child);
        if (index < this.fChildren.size()) {
            IDocumentElementNode previousSibling = null;
            if (index != 0) {
                previousSibling = this.fChildren.get(index - 1);
            }
            IDocumentElementNode newNode = this.fChildren.get(index);
            newNode.setPreviousSibling(previousSibling);
        }
        return child;
    }

    @Override
    public void removeDocumentAttribute(IDocumentAttributeNode attr) {
        this.fAttributes.remove(attr.getAttributeName());
    }

    @Override
    public void removeTextNode() {
        this.fTextNode = null;
    }

    @Override
    public void setIsErrorNode(boolean isErrorNode) {
        this.fIsErrorNode = isErrorNode;
    }

    @Override
    public void setLength(int length) {
        this.fLength = length;
    }

    @Override
    public void setLineIndent(int indent) {
        this.fIndent = indent;
    }

    @Override
    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    @Override
    public void setParentNode(IDocumentElementNode node) {
        this.fParent = node;
    }

    @Override
    public void setPreviousSibling(IDocumentElementNode sibling) {
        this.fPreviousSibling = sibling;
    }

    @Override
    public void setXMLAttribute(IDocumentAttributeNode attribute) {
        this.fAttributes.put(attribute.getAttributeName(), attribute);
    }

    @Override
    public boolean setXMLAttribute(String name, String value) {
        String oldValue;
        if (name == null || name.length() == 0) {
            return false;
        }
        if (value == null) {
            value = "";
        }
        if ((oldValue = this.getXMLAttributeValue(name)) != null && oldValue.equals(value)) {
            return false;
        }
        IDocumentAttributeNode attribute = this.getNodeAttributesMap().get(name);
        try {
            if (attribute == null) {
                attribute = this.createDocumentAttributeNode();
                attribute.setAttributeName(name);
                attribute.setEnclosingElement(this);
                this.setXMLAttribute(attribute);
            }
            attribute.setAttributeValue(value);
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setXMLContent(String text) {
        IDocumentTextNode node;
        if (text == null) {
            text = "";
        }
        if ((node = this.getTextNode()) == null) {
            node = this.createDocumentTextNode();
            node.setEnclosingElement(this);
            this.addTextNode(node);
        }
        node.setText(text);
        return true;
    }

    @Override
    public void setXMLTagName(String tag) {
        this.fTag = tag;
    }

    @Override
    public void swap(IDocumentElementNode child1, IDocumentElementNode child2) {
        int index1 = this.fChildren.indexOf(child1);
        int index2 = this.fChildren.indexOf(child2);
        this.fChildren.set(index1, child2);
        this.fChildren.set(index2, child1);
        child1.setPreviousSibling(index2 == 0 ? null : this.fChildren.get(index2 - 1));
        child2.setPreviousSibling(index1 == 0 ? null : this.fChildren.get(index1 - 1));
        if (index1 < this.fChildren.size() - 1) {
            this.fChildren.get(index1 + 1).setPreviousSibling(child2);
        }
        if (index2 < this.fChildren.size() - 1) {
            this.fChildren.get(index2 + 1).setPreviousSibling(child1);
        }
    }

    @Override
    public String write() {
        return this.write(false);
    }

    @Override
    public String write(boolean indent) {
        StringBuffer buffer = new StringBuffer();
        boolean hasChildren = this.hasXMLChildren();
        boolean hasContent = this.hasXMLContent();
        boolean terminate = this.canTerminateStartTag();
        if (this.isRoot()) {
            buffer.append(this.writeXMLDecl());
        }
        if (indent) {
            buffer.append(this.getIndent());
        }
        buffer.append(this.writeShallow(terminate));
        if (hasChildren) {
            IDocumentElementNode[] children;
            IDocumentElementNode[] iDocumentElementNodeArray = children = this.getChildNodes();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode element = iDocumentElementNodeArray[n2];
                element.setLineIndent(this.getLineIndent() + 3);
                buffer.append(String.valueOf(this.getLineDelimiter()) + element.write(true));
                ++n2;
            }
        }
        if (hasContent) {
            buffer.append(this.writeXMLContent());
        }
        if (!terminate) {
            buffer.append(this.getTerminateIndent());
            buffer.append("</");
            buffer.append(this.getXMLTagName());
            buffer.append(">");
        }
        return buffer.toString();
    }

    @Override
    public String writeShallow(boolean terminate) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(this.getXMLTagName());
        buffer.append(this.writeAttributes());
        if (terminate) {
            buffer.append("/");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private void linkNodeWithSiblings(IDocumentElementNode targetNode) {
        IDocumentElementNode parentNode = targetNode.getParentNode();
        if (parentNode == null) {
            return;
        }
        int targetNodePosition = parentNode.indexOf(targetNode);
        int parentNodeChildCount = parentNode.getChildCount();
        if (targetNodePosition <= 0) {
            targetNode.setPreviousSibling(null);
        } else if (targetNodePosition >= 1 && parentNodeChildCount >= 2) {
            IDocumentElementNode previousNode = parentNode.getChildAt(targetNodePosition - 1);
            targetNode.setPreviousSibling(previousNode);
        }
        int secondLastNodeIndex = parentNodeChildCount - 2;
        if (targetNodePosition >= 0 && targetNodePosition <= secondLastNodeIndex && parentNodeChildCount >= 2) {
            IDocumentElementNode nextNode = parentNode.getChildAt(targetNodePosition + 1);
            nextNode.setPreviousSibling(targetNode);
        }
    }

    private void reconnectAttributes() {
        for (String key : this.fAttributes.keySet()) {
            IDocumentAttributeNode attribute = this.fAttributes.get(key);
            attribute.reconnect(this);
        }
    }

    private void reconnectChildren(IModel model) {
        int i = 0;
        while (i < this.fChildren.size()) {
            IDocumentElementNode child = this.fChildren.get(i);
            child.reconnect(this, model);
            ++i;
        }
    }

    private void reconnectDocument() {
        this.fIndent = 0;
        this.fIsErrorNode = false;
        this.fLength = -1;
        this.fOffset = -1;
    }

    private void reconnectParent(IDocumentElementNode parent) {
        this.fParent = parent;
    }

    private void reconnectPreviousSibling() {
        this.linkNodeWithSiblings(this);
    }

    private void reconnectText() {
        if (this.fTextNode != null) {
            this.fTextNode.reconnect(this);
        }
    }

    protected IDocumentAttributeNode createDocumentAttributeNode() {
        return new DocumentAttributeNode();
    }

    protected IDocumentTextNode createDocumentTextNode() {
        return new DocumentTextNode();
    }

    protected String getAttributeIndent() {
        return String.valueOf(this.getLineDelimiter()) + this.getIndent() + "      ";
    }

    protected String getContentIndent() {
        return String.valueOf(this.getLineDelimiter()) + this.getIndent() + "   ";
    }

    protected String getFileEncoding() {
        return ATTRIBUTE_VALUE_ENCODING;
    }

    protected String getLineDelimiter() {
        return System.getProperty("line.separator");
    }

    protected String getTerminateIndent() {
        return String.valueOf(this.getLineDelimiter()) + this.getIndent();
    }

    protected boolean isDefined(IDocumentAttributeNode attribute) {
        if (attribute == null) {
            return false;
        }
        return attribute.getAttributeValue().trim().length() > 0;
    }

    protected boolean isDefined(IDocumentTextNode node) {
        if (node == null) {
            return false;
        }
        return MTJTextHelper.isDefinedAfterTrim(node.getText());
    }

    protected String writeAttributes() {
        IDocumentAttributeNode[] attributes;
        StringBuffer buffer = new StringBuffer();
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = attributes = this.getNodeAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode attribute = iDocumentAttributeNodeArray[n2];
            if (this.isDefined(attribute)) {
                buffer.append(String.valueOf(this.getAttributeIndent()) + attribute.write());
            }
            ++n2;
        }
        return buffer.toString();
    }

    protected String writeXMLContent() {
        StringBuffer buffer = new StringBuffer();
        if (this.isDefined(this.fTextNode)) {
            buffer.append(this.getContentIndent());
            buffer.append(this.fTextNode.write());
        }
        return buffer.toString();
    }

    protected String writeXMLDecl() {
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"");
        buffer.append(this.getFileEncoding());
        buffer.append("\"");
        buffer.append("?>");
        buffer.append(this.getLineDelimiter());
        return buffer.toString();
    }
}

