/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.text.DocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.DocumentGenericNode;
import org.eclipse.mtj.internal.core.text.DocumentTextNode;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentNodeFactory;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;

public abstract class DocumentNodeFactory
implements IDocumentNodeFactory {
    public IDocumentAttributeNode createAttribute(String name, String value, IDocumentElementNode enclosingElement) {
        DocumentAttributeNode attribute = new DocumentAttributeNode();
        try {
            attribute.setAttributeName(name);
            attribute.setAttributeValue(value);
        }
        catch (CoreException coreException) {}
        attribute.setEnclosingElement(enclosingElement);
        return attribute;
    }

    public IDocumentElementNode createDocumentNode(String name, IDocumentElementNode parent) {
        return this.createGeneric(name);
    }

    public IDocumentTextNode createDocumentTextNode(String content, IDocumentElementNode parent) {
        DocumentTextNode textNode = new DocumentTextNode();
        textNode.setEnclosingElement(parent);
        parent.addTextNode(textNode);
        textNode.setText(content);
        return textNode;
    }

    protected IDocumentElementNode createGeneric(String name) {
        return new DocumentGenericNode(name);
    }
}

