/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class ColonDelimitedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    public ColonDelimitedProperties() {
    }

    public ColonDelimitedProperties(Properties defaults) {
        super(defaults);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        InputStreamReader dataReader = new InputStreamReader(inStream, "UTF-8");
        this.load(dataReader);
    }

    public synchronized void load(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                int colonIndex;
                if ((line = line.trim()).length() <= 0 || line.startsWith("#") || (colonIndex = line.indexOf(58)) == -1) continue;
                String name = line.substring(0, colonIndex);
                if (colonIndex + 1 >= line.length()) continue;
                String value = line.substring(colonIndex + 1).trim();
                this.setProperty(name, value);
            }
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        ArrayList<Object> keys = new ArrayList<Object>(this.keySet());
        Collections.sort(keys);
        for (String string : keys) {
            String value = this.getProperty(string);
            writer.println(String.valueOf(string) + ": " + value);
        }
        writer.flush();
    }
}

