/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceableParametersProcessor {
    private static Pattern OPTIONAL_BLOCK_PATTERN = Pattern.compile("\\[%(.*?)%\\|(.*?)\\]");
    private static Pattern PROPS_PATTERN = Pattern.compile("%(.*?)%");
    private static final String TEMP_PROP = "__mtjTemp";

    public static String processReplaceableValues(String replaceableString, Map<String, String> replacementValues) {
        replacementValues.put(TEMP_PROP, replaceableString);
        String resolved = ReplaceableParametersProcessor.getResolvedPropertyValue(TEMP_PROP, replacementValues);
        replacementValues.remove(TEMP_PROP);
        return resolved;
    }

    private static String getResolvedPropertyValue(String key, Map<String, String> values) {
        String valueObject = values.get(key);
        String value = valueObject == null ? "" : valueObject.toString();
        StringBuffer sb = new StringBuffer(value);
        ReplaceableParametersProcessor.resolveOptionalBlocks(sb, values);
        ReplaceableParametersProcessor.resolvePropertyValues(sb, values);
        value = sb.toString();
        values.put(key, value);
        return value;
    }

    private static void resolveOptionalBlocks(StringBuffer sb, Map<String, String> values) {
        int offset = 0;
        Matcher matcher = OPTIONAL_BLOCK_PATTERN.matcher(sb);
        if (matcher.find()) {
            while (matcher.find(offset)) {
                String booleanProperty = matcher.group(1);
                String blockValue = matcher.group(2);
                String booleanPropertyValue = ReplaceableParametersProcessor.getResolvedPropertyValue(booleanProperty, values);
                String replacement = "";
                if (booleanPropertyValue != null && booleanPropertyValue.length() > 0) {
                    replacement = blockValue;
                }
                sb.replace(matcher.start(), matcher.end(), replacement);
                offset = matcher.start() + replacement.length();
            }
        }
    }

    private static void resolvePropertyValues(StringBuffer sb, Map<String, String> values) {
        int offset = 0;
        Matcher matcher = PROPS_PATTERN.matcher(sb);
        if (matcher.find()) {
            while (matcher.find(offset)) {
                String propertyName = matcher.group(1);
                String propertyValue = ReplaceableParametersProcessor.getResolvedPropertyValue(propertyName, values);
                if (propertyValue == null) continue;
                sb.replace(matcher.start(), matcher.end(), propertyValue);
                offset = matcher.start() + propertyValue.length();
            }
        }
    }

    private ReplaceableParametersProcessor() {
    }
}

