/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.mtj.internal.core.util.Utils;

public class TemporaryFileManager {
    public static final TemporaryFileManager instance = new TemporaryFileManager();
    private File mtjTempFolder;

    private TemporaryFileManager() {
    }

    public File createTempDirectory(String prefix, String suffix) throws IOException {
        return this.createTempDirectory(prefix, suffix, this.getMTJTempFolder());
    }

    public synchronized File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        while (prefix.length() < 3) {
            prefix = String.valueOf(prefix) + "_";
        }
        File file = File.createTempFile(prefix, suffix, directory);
        file.delete();
        file.mkdir();
        return file;
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return this.createTempFile(prefix, suffix, this.getMTJTempFolder());
    }

    public synchronized File createTempFile(String prefix, String suffix, File directory) throws IOException {
        while (prefix.length() < 3) {
            prefix = String.valueOf(prefix) + "_";
        }
        File file = File.createTempFile(prefix, suffix, directory);
        file.deleteOnExit();
        return file;
    }

    private File getMTJTempFolder() {
        if (this.mtjTempFolder == null) {
            String userName = System.getProperty("user.name", "").replace(' ', '_');
            this.mtjTempFolder = new File(this.getSystemTempFolder(), "_mtj.tmp" + userName);
            if (this.mtjTempFolder.exists()) {
                if (this.shouldClearTempFolderOnStartup()) {
                    Utils.delete(this.mtjTempFolder);
                    this.mtjTempFolder.mkdirs();
                }
            } else {
                this.mtjTempFolder.mkdirs();
            }
        }
        return this.mtjTempFolder;
    }

    private File getSystemTempFolder() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private boolean shouldClearTempFolderOnStartup() {
        return System.getProperty("mtj.cleartemp", "true").equalsIgnoreCase("true");
    }
}

