/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTool {
    public static final String JAVA_APP_LAUNCH_ID = "org.eclipse.jdt.launching.localJavaApplication";
    private static final IStatus promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    private static final IStatus delegateNotAvailable = new Status(1, "org.eclipse.debug.core", 226, "", null);

    protected abstract String[] getArguments();

    protected abstract String getClassName();

    protected abstract String[] getClasspath();

    protected abstract String getName();

    protected abstract String[] getVMArguments();

    public ILaunch launch(IProgressMonitor monitor) throws CoreException {
        Launch launch = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType(JAVA_APP_LAUNCH_ID);
        ILaunchConfigurationWorkingCopy launchConfig = launchType.newInstance(null, this.getName());
        this.fillLaunchConfig(launchConfig);
        launch = new Launch((ILaunchConfiguration)launchConfig, "run", null);
        HashSet<String> modes = new HashSet<String>();
        modes.add("run");
        ILaunchDelegate[] delegates = launchType.getDelegates(modes);
        ILaunchConfigurationDelegate delegate = null;
        if (delegates.length == 1) {
            delegate = delegates[0].getDelegate();
        } else if (delegates.length == 0) {
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(promptStatus);
            if (handler != null) {
                handler.handleStatus(delegateNotAvailable, (Object)new Object[]{this, "run"});
            }
            Status status = new Status(8, DebugPlugin.getUniqueIdentifier(), 4, Messages.AbstractJavaTool_delegateNotAvailable, null);
            throw new CoreException((IStatus)status);
        }
        delegate.launch((ILaunchConfiguration)launchConfig, "run", (ILaunch)launch, monitor);
        Utils.dumpCommandLine((ILaunch)launch);
        return launch;
    }

    private void fillLaunchConfig(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getClassName());
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, this.getClasspathMementos());
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArgumentsString());
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArgumentsString());
    }

    private String getArgumentsString(String[] arguments) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < arguments.length) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(arguments[i]);
            ++i;
        }
        return sb.toString();
    }

    private void addStandardLibraries(List<String> mementos) throws CoreException {
        LibraryLocation[] libs;
        IVMInstall vm = JavaRuntime.getDefaultVMInstall();
        if (vm != null && (libs = JavaRuntime.getLibraryLocations((IVMInstall)vm)) != null) {
            int i = 0;
            while (i < libs.length) {
                IPath location = libs[i].getSystemLibraryPath();
                IRuntimeClasspathEntry r = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)location);
                r.setClasspathProperty(1);
                mementos.add(r.getMemento());
                ++i;
            }
        }
    }

    private List<String> getClasspathMementos() throws CoreException {
        String[] cpEntries = this.getClasspath();
        ArrayList<String> mementos = new ArrayList<String>(cpEntries.length);
        int i = 0;
        while (i < cpEntries.length) {
            String cpEntry = cpEntries[i];
            IRuntimeClasspathEntry rcpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(cpEntry));
            mementos.add(rcpEntry.getMemento());
            ++i;
        }
        this.addStandardLibraries(mementos);
        return mementos;
    }

    private String getProgramArgumentsString() {
        return this.getArgumentsString(this.getArguments());
    }

    private String getVMArgumentsString() {
        return this.getArgumentsString(this.getVMArguments());
    }
}

