/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.templates;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mtj.ui.templates.AbstractTemplateWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleTemplatePage
extends AbstractTemplateWizardPage {
    private static final String COLOR_REG_EXP = "(0x)([a-fA-F0-9]){6}";
    private Text bgColorText;
    private Text fgColorText;
    private Button faceSystemBtn;
    private Button faceMonospaceBtn;
    private Button faceProportionalBtn;
    private Button styleBoldBtn;
    private Button styleItalicBtn;
    private Button styleUnderlineBtn;
    private Button sizeSmallBtn;
    private Button sizeMediumBtn;
    private Button sizeLargeBtn;
    private Text msgText;

    public Map<String, String> getDictionary() {
        HashMap<String, String> dict = new HashMap<String, String>();
        dict.put("$message$", this.msgText.getText());
        dict.put("$bg$", this.bgColorText.getText());
        dict.put("$fg$", this.fgColorText.getText());
        dict.put("$font-face$", this.getFontFace());
        dict.put("$font-style$", this.getFontStyle());
        dict.put("$font-size$", this.getFontSize());
        return dict;
    }

    public boolean isPageComplete() {
        boolean result = true;
        result &= Pattern.matches(COLOR_REG_EXP, this.bgColorText.getText());
        result &= Pattern.matches(COLOR_REG_EXP, this.fgColorText.getText());
        return result &= this.msgText.getText().length() > 0;
    }

    public void createControl(Composite parent) {
        GridData gridData = null;
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite, 0);
        group.setText("Text Design:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label textLabel = new Label((Composite)group, 0);
        textLabel.setText("Text Message:");
        gridData = new GridData(4);
        textLabel.setLayoutData((Object)gridData);
        this.msgText = new Text((Composite)group, 2048);
        this.msgText.setText("MTJ Rocks...");
        gridData = new GridData(768);
        this.msgText.setLayoutData((Object)gridData);
        this.msgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExampleTemplatePage.this.getWizard().getContainer().updateButtons();
            }
        });
        group = new Group(composite, 0);
        group.setText("Color Design:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label bgColorLabel = new Label((Composite)group, 0);
        bgColorLabel.setText("Background Color (0xXXXXXX):");
        gridData = new GridData(4);
        bgColorLabel.setLayoutData((Object)gridData);
        this.bgColorText = new Text((Composite)group, 2048);
        this.bgColorText.setText("0xFFFFFF");
        gridData = new GridData(768);
        this.bgColorText.setLayoutData((Object)gridData);
        this.bgColorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExampleTemplatePage.this.getWizard().getContainer().updateButtons();
            }
        });
        Label fgColorLabel = new Label((Composite)group, 0);
        fgColorLabel.setText("Text Color (0xXXXXXX):");
        gridData = new GridData(4);
        fgColorLabel.setLayoutData((Object)gridData);
        this.fgColorText = new Text((Composite)group, 2048);
        this.fgColorText.setText("0x000000");
        gridData = new GridData(768);
        this.fgColorText.setLayoutData((Object)gridData);
        this.fgColorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExampleTemplatePage.this.getWizard().getContainer().updateButtons();
            }
        });
        Group fontGroup = new Group(composite, 0);
        fontGroup.setText("Font Design:");
        fontGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        fontGroup.setLayout((Layout)new GridLayout(1, false));
        group = new Group((Composite)fontGroup, 0);
        group.setText("Font Face:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.faceSystemBtn = new Button((Composite)group, 16);
        this.faceSystemBtn.setText("System");
        gridData = new GridData(768);
        this.faceSystemBtn.setLayoutData((Object)gridData);
        this.faceSystemBtn.setSelection(true);
        this.faceMonospaceBtn = new Button((Composite)group, 16);
        this.faceMonospaceBtn.setText("Monospace");
        gridData = new GridData(768);
        this.faceMonospaceBtn.setLayoutData((Object)gridData);
        this.faceProportionalBtn = new Button((Composite)group, 16);
        this.faceProportionalBtn.setText("Proportional");
        gridData = new GridData(768);
        this.faceProportionalBtn.setLayoutData((Object)gridData);
        group = new Group((Composite)fontGroup, 0);
        group.setText("Font Style:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.styleBoldBtn = new Button((Composite)group, 32);
        this.styleBoldBtn.setText("Bold");
        gridData = new GridData(768);
        this.styleBoldBtn.setLayoutData((Object)gridData);
        this.styleBoldBtn.setSelection(true);
        this.styleItalicBtn = new Button((Composite)group, 32);
        this.styleItalicBtn.setText("Italic");
        gridData = new GridData(768);
        this.styleItalicBtn.setLayoutData((Object)gridData);
        this.styleItalicBtn.setSelection(true);
        this.styleUnderlineBtn = new Button((Composite)group, 32);
        this.styleUnderlineBtn.setText("Underline");
        gridData = new GridData(768);
        this.styleUnderlineBtn.setLayoutData((Object)gridData);
        this.styleUnderlineBtn.setSelection(true);
        group = new Group((Composite)fontGroup, 0);
        group.setText("Font Size:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.sizeSmallBtn = new Button((Composite)group, 16);
        this.sizeSmallBtn.setText("Small");
        gridData = new GridData(768);
        this.sizeSmallBtn.setLayoutData((Object)gridData);
        this.sizeMediumBtn = new Button((Composite)group, 16);
        this.sizeMediumBtn.setText("Medium");
        gridData = new GridData(768);
        this.sizeMediumBtn.setLayoutData((Object)gridData);
        this.sizeLargeBtn = new Button((Composite)group, 16);
        this.sizeLargeBtn.setText("Large");
        gridData = new GridData(768);
        this.sizeLargeBtn.setLayoutData((Object)gridData);
        this.sizeLargeBtn.setSelection(true);
        this.setControl((Control)composite);
    }

    private String getFontSize() {
        StringBuffer buffer = new StringBuffer();
        if (this.sizeSmallBtn.getSelection()) {
            buffer.append("Font.SIZE_SMALL");
        } else if (this.sizeMediumBtn.getSelection()) {
            buffer.append("Font.SIZE_MEDIUM");
        } else if (this.sizeLargeBtn.getSelection()) {
            buffer.append("Font.SIZE_LARGE");
        }
        return buffer.toString();
    }

    private String getFontStyle() {
        StringBuffer buffer = new StringBuffer();
        if (this.styleBoldBtn.getSelection()) {
            buffer.append("Font.STYLE_BOLD");
        }
        if (this.styleItalicBtn.getSelection()) {
            if (buffer.length() > 0) {
                buffer.append(" | ");
            }
            buffer.append("Font.STYLE_ITALIC");
        }
        if (this.styleUnderlineBtn.getSelection()) {
            if (buffer.length() > 0) {
                buffer.append(" | ");
            }
            buffer.append("Font.STYLE_UNDERLINED");
        }
        if (buffer.length() == 0) {
            buffer.append("Font.STYLE_PLAIN");
        }
        return buffer.toString();
    }

    private String getFontFace() {
        StringBuffer buffer = new StringBuffer();
        if (this.faceSystemBtn.getSelection()) {
            buffer.append("Font.FACE_SYSTEM");
        } else if (this.faceMonospaceBtn.getSelection()) {
            buffer.append("Font.FACE_MONOSPACE");
        } else if (this.faceProportionalBtn.getSelection()) {
            buffer.append("Font.FACE_PROPORTIONAL");
        }
        return buffer.toString();
    }
}

