/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.wizards.testsuite;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.junit.wizards.NewTestSuiteWizardPage;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.jmunit.JMUnitMessages;
import org.eclipse.mtj.internal.jmunit.core.api.TestSuiteWriter;
import org.eclipse.mtj.internal.jmunit.ui.wizards.testsuite.SuiteClassesContentProvider;
import org.eclipse.mtj.internal.jmunit.util.JMUnitStatus;
import org.eclipse.mtj.internal.jmunit.util.LayoutUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewJMUnitTestSuiteWizardPageOne
extends NewTestSuiteWizardPage {
    private static final String PAGE_NAME = "NewJMUnitTestSuiteWizardPageOne";
    public static final String CLASSES_IN_SUITE = "NewJMUnitTestSuiteWizardPageOne.classesinsuite";
    private static final String ALL_TESTS = "AllTestSuite";
    private IStatus fClassesInSuiteStatus;
    private CheckboxTableViewer fClassesInSuiteTable;
    private Label fSelectedClassesLabel;
    private boolean fUpdatedExistingClassButton;
    private SuiteClassesContentProvider provider;

    public NewJMUnitTestSuiteWizardPageOne() {
        this.setTitle(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_title);
        this.setDescription(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_description);
        this.fClassesInSuiteStatus = new JMUnitStatus();
        this.provider = new SuiteClassesContentProvider("jmunit.framework.cldc11.TestCase");
    }

    public String getSuperClass() {
        return "jmunit.framework.cldc11.TestSuite";
    }

    public boolean hasUpdatedExistingClass() {
        return this.fUpdatedExistingClassButton;
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.setTypeName(ALL_TESTS, true);
        this.fTypeNameStatus = this.typeNameChanged();
    }

    private IStatus classesInSuiteChanged() {
        JMUnitStatus status = new JMUnitStatus();
        if (this.fClassesInSuiteTable.getCheckedElements().length <= 0) {
            status.setWarning(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_no_test_classes_selected);
        }
        return status;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createClassesInSuiteControl(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fClassesInSuiteStatus};
        this.updateStatus(status);
    }

    private void updateSelectedClassesLabel() {
        int noOfClassesChecked = this.fClassesInSuiteTable.getCheckedElements().length;
        String key = noOfClassesChecked == 1 ? JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_class_selected : JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_classes_selected;
        this.fSelectedClassesLabel.setText(NLS.bind((String)key, (Object)new Integer(noOfClassesChecked)));
    }

    protected void createClassesInSuiteControl(Composite parent, int nColumns) {
        if (this.fClassesInSuiteTable == null) {
            Label label = new Label(parent, 16384);
            label.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_createClassesInSuiteControl_label);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = nColumns;
            label.setLayoutData((Object)gd);
            this.fClassesInSuiteTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            gd = new GridData(1808);
            gd.heightHint = 80;
            gd.horizontalSpan = nColumns - 1;
            this.fClassesInSuiteTable.getTable().setLayoutData((Object)gd);
            this.fClassesInSuiteTable.setContentProvider((IContentProvider)this.provider);
            this.fClassesInSuiteTable.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
            this.fClassesInSuiteTable.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    NewJMUnitTestSuiteWizardPageOne.this.handleFieldChanged(NewJMUnitTestSuiteWizardPageOne.CLASSES_IN_SUITE);
                }
            });
            this.fClassesInSuiteTable.setInput((Object)this.getJavaProject());
            Composite buttonContainer = new Composite(parent, 0);
            gd = new GridData(1040);
            buttonContainer.setLayoutData((Object)gd);
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.marginWidth = 0;
            buttonLayout.marginHeight = 0;
            buttonContainer.setLayout((Layout)buttonLayout);
            Button selectAllButton = new Button(buttonContainer, 8);
            selectAllButton.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_select_all);
            GridData bgd = new GridData(770);
            bgd.widthHint = LayoutUtil.getButtonWidthHint(selectAllButton);
            selectAllButton.setLayoutData((Object)bgd);
            selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewJMUnitTestSuiteWizardPageOne.this.fClassesInSuiteTable.setAllChecked(true);
                    NewJMUnitTestSuiteWizardPageOne.this.handleFieldChanged(NewJMUnitTestSuiteWizardPageOne.CLASSES_IN_SUITE);
                }
            });
            Button deselectAllButton = new Button(buttonContainer, 8);
            deselectAllButton.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_deselect_all);
            bgd = new GridData(770);
            bgd.widthHint = LayoutUtil.getButtonWidthHint(deselectAllButton);
            deselectAllButton.setLayoutData((Object)bgd);
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewJMUnitTestSuiteWizardPageOne.this.fClassesInSuiteTable.setAllChecked(false);
                    NewJMUnitTestSuiteWizardPageOne.this.handleFieldChanged(NewJMUnitTestSuiteWizardPageOne.CLASSES_IN_SUITE);
                }
            });
            this.fSelectedClassesLabel = new Label(parent, 16448);
            this.fSelectedClassesLabel.setFont(parent.getFont());
            this.updateSelectedClassesLabel();
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.fSelectedClassesLabel.setLayoutData((Object)gd);
        }
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        Object[] types = this.fClassesInSuiteTable.getCheckedElements();
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            IType targetType = (IType)types[i];
            names[i] = targetType.getElementName();
            if (!targetType.getPackageFragment().getElementName().equals(type.getPackageFragment().getElementName())) {
                String importName = targetType.getFullyQualifiedName();
                type.getCompilationUnit().createImport(importName, null, monitor);
            }
            ++i;
        }
        TestSuiteWriter writer = new TestSuiteWriter(type, type.getElementName());
        writer.writeCode(names, monitor);
    }

    protected void handleFieldChanged(String fieldName) {
        if (fieldName.equals("NewTypeWizardPage.package") || fieldName.equals("NewContainerWizardPage.container")) {
            this.updateClassesInSuiteTable();
        } else if (fieldName.equals(CLASSES_IN_SUITE)) {
            this.fClassesInSuiteStatus = this.classesInSuiteChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.updateSelectedClassesLabel();
        }
        this.doStatusUpdate();
    }

    protected void updateClassesInSuiteTable() {
        if (this.fClassesInSuiteTable != null) {
            this.fClassesInSuiteTable.setInput((Object)this.getJavaProject());
            this.fClassesInSuiteTable.setAllChecked(true);
            this.updateSelectedClassesLabel();
        }
    }
}

