/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mtj.internal.jmunit.JMUnitPlugin;

public class JMUnitStatus
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;

    public static IStatus createError(String message) {
        return new JMUnitStatus(4, message);
    }

    public static IStatus createInfo(String message) {
        return new JMUnitStatus(1, message);
    }

    public static IStatus createWarning(String message) {
        return new JMUnitStatus(2, message);
    }

    public JMUnitStatus() {
        this(0, null);
    }

    public JMUnitStatus(int severity, String message) {
        this.fStatusMessage = message;
        this.fSeverity = severity;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }

    public int getCode() {
        return this.fSeverity;
    }

    public Throwable getException() {
        return null;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public String getPlugin() {
        return JMUnitPlugin.getPluginId();
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean matches(int severityMask) {
        return (this.fSeverity & severityMask) != 0;
    }

    public void setError(String errorMessage) {
        Assert.isNotNull((Object)errorMessage);
        this.fStatusMessage = errorMessage;
        this.fSeverity = 4;
    }

    public void setInfo(String infoMessage) {
        Assert.isNotNull((Object)infoMessage);
        this.fStatusMessage = infoMessage;
        this.fSeverity = 1;
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public void setWarning(String warningMessage) {
        Assert.isNotNull((Object)warningMessage);
        this.fStatusMessage = warningMessage;
        this.fSeverity = 2;
    }
}

