/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.internal.core.util.IJavaProjectVisitor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class JMUnitTestsVisitor
implements IJavaProjectVisitor {
    private static final String[] JMUNIT_TESTS = new String[]{"jmunit.framework.cldc11.TestCase", "jmunit.framework.cldc11.TestSuite"};
    private List<IResource> excludeds = new ArrayList<IResource>();
    private IJavaProject javaProject;

    public JMUnitTestsVisitor(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void visitCompilatioUnit(ICompilationUnit compilationUnit) {
        IType type = compilationUnit.findPrimaryType();
        try {
            IType[] types;
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = types = hierarchy.getAllClasses();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                String superClass = iType.getFullyQualifiedName('.');
                String[] stringArray = JMUNIT_TESTS;
                int n3 = JMUNIT_TESTS.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource resource;
                    String jmunitTestName = stringArray[n4];
                    if (superClass.equals(jmunitTestName) && (resource = compilationUnit.getCorrespondingResource()) != null) {
                        this.excludeds.add(resource);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    public IPath[] getJMunitTests() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IResource[] sources = Utils.getSourceFolders((IJavaProject)this.javaProject);
        block0: for (IResource excluded : this.excludeds) {
            IPath path = excluded.getProjectRelativePath();
            IResource[] iResourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource source = iResourceArray[n2];
                IPath sourcePath = source.getProjectRelativePath();
                if (sourcePath.isPrefixOf(path)) {
                    paths.add(path.removeFirstSegments(sourcePath.segmentCount()));
                    continue block0;
                }
                ++n2;
            }
        }
        return paths.toArray(new IPath[0]);
    }

    public void visitPackageFragment(IPackageFragment fragment) {
    }

    public void visitPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
    }
}

